<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressToValidateList StructType
 * @subpackage Structs
 */
class AddressToValidateList extends AbstractStructBase
{
    /**
     * The AddressToValidate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 200
     * @var \StructType\AddressToValidateType[]
     */
    public $AddressToValidate;
    /**
     * Constructor method for AddressToValidateList
     * @uses AddressToValidateList::setAddressToValidate()
     * @param \StructType\AddressToValidateType[] $addressToValidate
     */
    public function __construct(array $addressToValidate = array())
    {
        $this
            ->setAddressToValidate($addressToValidate);
    }
    /**
     * Get AddressToValidate value
     * @return \StructType\AddressToValidateType[]|null
     */
    public function getAddressToValidate()
    {
        return $this->AddressToValidate;
    }
    /**
     * Set AddressToValidate value
     * @throws \InvalidArgumentException
     * @param \StructType\AddressToValidateType[] $addressToValidate
     * @return \StructType\AddressToValidateList
     */
    public function setAddressToValidate(array $addressToValidate = array())
    {
        foreach ($addressToValidate as $addressToValidateListAddressToValidateItem) {
            // validation for constraint: itemType
            if (!$addressToValidateListAddressToValidateItem instanceof \StructType\AddressToValidateType) {
                throw new \InvalidArgumentException(sprintf('The AddressToValidate property can only contain items of \StructType\AddressToValidateType, "%s" given', is_object($addressToValidateListAddressToValidateItem) ? get_class($addressToValidateListAddressToValidateItem) : gettype($addressToValidateListAddressToValidateItem)), __LINE__);
            }
        }
        $this->AddressToValidate = $addressToValidate;
        return $this;
    }
    /**
     * Add item to AddressToValidate value
     * @throws \InvalidArgumentException
     * @param \StructType\AddressToValidateType $item
     * @return \StructType\AddressToValidateList
     */
    public function addToAddressToValidate(\StructType\AddressToValidateType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AddressToValidateType) {
            throw new \InvalidArgumentException(sprintf('The AddressToValidate property can only contain items of \StructType\AddressToValidateType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AddressToValidate[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddressToValidateList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
