<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressToFormatType StructType
 * @subpackage Structs
 */
class AddressToFormatType extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The AddressBlockLines
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AddressBlockLinesType
     */
    public $AddressBlockLines;
    /**
     * The MaileeAndAddressee
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\StructuredMaileeAndAddresseeType
     */
    public $MaileeAndAddressee;
    /**
     * The PostalAddress
     * @var \StructType\StructuredPostalAddressType
     */
    public $PostalAddress;
    /**
     * The AddressLanguage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: msg:AddressLanguage
     * @var string
     */
    public $AddressLanguage;
    /**
     * The DispatchingCountryISOCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: msg:DispatchingCountryISOCode
     * - documentation: ISO 3166-1 alpha-2 country code
     * @var string
     */
    public $DispatchingCountryISOCode;
    /**
     * The DeliveringCountryISOCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: msg:DeliveringCountryISOCode
     * - documentation: ISO 3166-1 alpha-2 country code
     * @var string
     */
    public $DeliveringCountryISOCode;
    /**
     * Constructor method for AddressToFormatType
     * @uses AddressToFormatType::setId()
     * @uses AddressToFormatType::setAddressBlockLines()
     * @uses AddressToFormatType::setMaileeAndAddressee()
     * @uses AddressToFormatType::setPostalAddress()
     * @uses AddressToFormatType::setAddressLanguage()
     * @uses AddressToFormatType::setDispatchingCountryISOCode()
     * @uses AddressToFormatType::setDeliveringCountryISOCode()
     * @param string $id
     * @param \StructType\AddressBlockLinesType $addressBlockLines
     * @param \StructType\StructuredMaileeAndAddresseeType $maileeAndAddressee
     * @param \StructType\StructuredPostalAddressType $postalAddress
     * @param string $addressLanguage
     * @param string $dispatchingCountryISOCode
     * @param string $deliveringCountryISOCode
     */
    public function __construct($id = null, \StructType\AddressBlockLinesType $addressBlockLines = null, \StructType\StructuredMaileeAndAddresseeType $maileeAndAddressee = null, \StructType\StructuredPostalAddressType $postalAddress = null, $addressLanguage = null, $dispatchingCountryISOCode = null, $deliveringCountryISOCode = null)
    {
        $this
            ->setId($id)
            ->setAddressBlockLines($addressBlockLines)
            ->setMaileeAndAddressee($maileeAndAddressee)
            ->setPostalAddress($postalAddress)
            ->setAddressLanguage($addressLanguage)
            ->setDispatchingCountryISOCode($dispatchingCountryISOCode)
            ->setDeliveringCountryISOCode($deliveringCountryISOCode);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\AddressToFormatType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get AddressBlockLines value
     * @return \StructType\AddressBlockLinesType|null
     */
    public function getAddressBlockLines()
    {
        return $this->AddressBlockLines;
    }
    /**
     * Set AddressBlockLines value
     * @param \StructType\AddressBlockLinesType $addressBlockLines
     * @return \StructType\AddressToFormatType
     */
    public function setAddressBlockLines(\StructType\AddressBlockLinesType $addressBlockLines = null)
    {
        $this->AddressBlockLines = $addressBlockLines;
        return $this;
    }
    /**
     * Get MaileeAndAddressee value
     * @return \StructType\StructuredMaileeAndAddresseeType|null
     */
    public function getMaileeAndAddressee()
    {
        return $this->MaileeAndAddressee;
    }
    /**
     * Set MaileeAndAddressee value
     * @param \StructType\StructuredMaileeAndAddresseeType $maileeAndAddressee
     * @return \StructType\AddressToFormatType
     */
    public function setMaileeAndAddressee(\StructType\StructuredMaileeAndAddresseeType $maileeAndAddressee = null)
    {
        $this->MaileeAndAddressee = $maileeAndAddressee;
        return $this;
    }
    /**
     * Get PostalAddress value
     * @return \StructType\StructuredPostalAddressType|null
     */
    public function getPostalAddress()
    {
        return $this->PostalAddress;
    }
    /**
     * Set PostalAddress value
     * @param \StructType\StructuredPostalAddressType $postalAddress
     * @return \StructType\AddressToFormatType
     */
    public function setPostalAddress(\StructType\StructuredPostalAddressType $postalAddress = null)
    {
        $this->PostalAddress = $postalAddress;
        return $this;
    }
    /**
     * Get AddressLanguage value
     * @return string|null
     */
    public function getAddressLanguage()
    {
        return $this->AddressLanguage;
    }
    /**
     * Set AddressLanguage value
     * @param string $addressLanguage
     * @return \StructType\AddressToFormatType
     */
    public function setAddressLanguage($addressLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($addressLanguage) && !is_string($addressLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressLanguage)), __LINE__);
        }
        $this->AddressLanguage = $addressLanguage;
        return $this;
    }
    /**
     * Get DispatchingCountryISOCode value
     * @return string|null
     */
    public function getDispatchingCountryISOCode()
    {
        return $this->DispatchingCountryISOCode;
    }
    /**
     * Set DispatchingCountryISOCode value
     * @param string $dispatchingCountryISOCode
     * @return \StructType\AddressToFormatType
     */
    public function setDispatchingCountryISOCode($dispatchingCountryISOCode = null)
    {
        // validation for constraint: string
        if (!is_null($dispatchingCountryISOCode) && !is_string($dispatchingCountryISOCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dispatchingCountryISOCode)), __LINE__);
        }
        $this->DispatchingCountryISOCode = $dispatchingCountryISOCode;
        return $this;
    }
    /**
     * Get DeliveringCountryISOCode value
     * @return string|null
     */
    public function getDeliveringCountryISOCode()
    {
        return $this->DeliveringCountryISOCode;
    }
    /**
     * Set DeliveringCountryISOCode value
     * @param string $deliveringCountryISOCode
     * @return \StructType\AddressToFormatType
     */
    public function setDeliveringCountryISOCode($deliveringCountryISOCode = null)
    {
        // validation for constraint: string
        if (!is_null($deliveringCountryISOCode) && !is_string($deliveringCountryISOCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveringCountryISOCode)), __LINE__);
        }
        $this->DeliveringCountryISOCode = $deliveringCountryISOCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddressToFormatType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
