<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Format ServiceType
 * @subpackage Services
 */
class Format extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named formatAddresses
     * Meta informations extracted from the WSDL
     * - documentation: Formats the given belgian address(es) and returns the result.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FormatAddressesRequestType $parameters
     * @return \StructType\FormatAddressesResponseType|bool
     */
    public function formatAddresses(\StructType\FormatAddressesRequestType $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->formatAddresses($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named formatUPUAddresses
     * Meta informations extracted from the WSDL
     * - documentation: Formats the given international address(es) in UPU standard format and returns the result.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FormatUPUAddressesRequestType $parameters
     * @return \StructType\FormatUPUAddressesResponseType|bool
     */
    public function formatUPUAddresses(\StructType\FormatUPUAddressesRequestType $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->formatUPUAddresses($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\FormatAddressesResponseType|\StructType\FormatUPUAddressesResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
