<?php

namespace EnumType;

/**
 * This class stands for CoordinateTypeType EnumType
 * @subpackage Enumerations
 */
class CoordinateTypeType
{
    /**
     * Constant for value 'DMS'
     * @return string 'DMS'
     */
    const VALUE_DMS = 'DMS';
    /**
     * Constant for value 'MINDEC'
     * @return string 'MINDEC'
     */
    const VALUE_MINDEC = 'MINDEC';
    /**
     * Constant for value 'DEGDEC'
     * @return string 'DEGDEC'
     */
    const VALUE_DEGDEC = 'DEGDEC';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DMS
     * @uses self::VALUE_MINDEC
     * @uses self::VALUE_DEGDEC
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DMS,
            self::VALUE_MINDEC,
            self::VALUE_DEGDEC,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
