<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WingType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Element identifying the building, unit or construction section in which it is housed and/or the main entry door through which it is accessed.(UPU)
 * @subpackage Structs
 */
class WingType extends AbstractStructBase
{
    /**
     * The WingType
     * Meta informations extracted from the WSDL
     * - documentation: S42 name: Wing Type, code: 30.29.0.0.1
     * - minOccurs: 0
     * @var string
     */
    public $WingType;
    /**
     * The WingIndicator
     * Meta informations extracted from the WSDL
     * - documentation: S42 name: Wing Indicator, code: 30.29.0.0.2
     * - minOccurs: 0
     * @var string
     */
    public $WingIndicator;
    /**
     * Constructor method for WingType
     * @uses WingType::setWingType()
     * @uses WingType::setWingIndicator()
     * @param string $wingType
     * @param string $wingIndicator
     */
    public function __construct($wingType = null, $wingIndicator = null)
    {
        $this
            ->setWingType($wingType)
            ->setWingIndicator($wingIndicator);
    }
    /**
     * Get WingType value
     * @return string|null
     */
    public function getWingType()
    {
        return $this->WingType;
    }
    /**
     * Set WingType value
     * @param string $wingType
     * @return \StructType\WingType
     */
    public function setWingType($wingType = null)
    {
        // validation for constraint: string
        if (!is_null($wingType) && !is_string($wingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($wingType)), __LINE__);
        }
        $this->WingType = $wingType;
        return $this;
    }
    /**
     * Get WingIndicator value
     * @return string|null
     */
    public function getWingIndicator()
    {
        return $this->WingIndicator;
    }
    /**
     * Set WingIndicator value
     * @param string $wingIndicator
     * @return \StructType\WingType
     */
    public function setWingIndicator($wingIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($wingIndicator) && !is_string($wingIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($wingIndicator)), __LINE__);
        }
        $this->WingIndicator = $wingIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WingType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
