<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidatedAddressList StructType
 * @subpackage Structs
 */
class ValidatedAddressList extends AbstractStructBase
{
    /**
     * The ValidatedAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ValidatedAddressType[]
     */
    public $ValidatedAddress;
    /**
     * Constructor method for ValidatedAddressList
     * @uses ValidatedAddressList::setValidatedAddress()
     * @param \StructType\ValidatedAddressType[] $validatedAddress
     */
    public function __construct(array $validatedAddress = array())
    {
        $this
            ->setValidatedAddress($validatedAddress);
    }
    /**
     * Get ValidatedAddress value
     * @return \StructType\ValidatedAddressType[]|null
     */
    public function getValidatedAddress()
    {
        return $this->ValidatedAddress;
    }
    /**
     * Set ValidatedAddress value
     * @throws \InvalidArgumentException
     * @param \StructType\ValidatedAddressType[] $validatedAddress
     * @return \StructType\ValidatedAddressList
     */
    public function setValidatedAddress(array $validatedAddress = array())
    {
        foreach ($validatedAddress as $validatedAddressListValidatedAddressItem) {
            // validation for constraint: itemType
            if (!$validatedAddressListValidatedAddressItem instanceof \StructType\ValidatedAddressType) {
                throw new \InvalidArgumentException(sprintf('The ValidatedAddress property can only contain items of \StructType\ValidatedAddressType, "%s" given', is_object($validatedAddressListValidatedAddressItem) ? get_class($validatedAddressListValidatedAddressItem) : gettype($validatedAddressListValidatedAddressItem)), __LINE__);
            }
        }
        $this->ValidatedAddress = $validatedAddress;
        return $this;
    }
    /**
     * Add item to ValidatedAddress value
     * @throws \InvalidArgumentException
     * @param \StructType\ValidatedAddressType $item
     * @return \StructType\ValidatedAddressList
     */
    public function addToValidatedAddress(\StructType\ValidatedAddressType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ValidatedAddressType) {
            throw new \InvalidArgumentException(sprintf('The ValidatedAddress property can only contain items of \StructType\ValidatedAddressType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ValidatedAddress[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ValidatedAddressList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
