<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructuredMailRecipientDispatchingInformationType
 * StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type representing physical address details of a building.
 * @subpackage Structs
 */
class StructuredMailRecipientDispatchingInformationType extends AbstractStructBase
{
    /**
     * The Wing
     * Meta informations extracted from the WSDL
     * - documentation: Element identifying the building, unit or construction section in which it is housed and/or the main entry door through which it is accessed.
     * - minOccurs: 0
     * @var \StructType\WingType
     */
    public $Wing;
    /**
     * The Stairwell
     * Meta informations extracted from the WSDL
     * - documentation: Element indicating access to floor or door within a building, unit or construction. E.g. escalier 1, staircase west.
     * - minOccurs: 0
     * @var \StructType\StairwellType
     */
    public $Stairwell;
    /**
     * The Floor
     * Meta informations extracted from the WSDL
     * - documentation: Element indicating the floor or level on which a delivery point is located in a multi-story construction.
     * - minOccurs: 0
     * @var \StructType\FloorType
     */
    public $Floor;
    /**
     * The Door
     * Meta informations extracted from the WSDL
     * - documentation: Address Element indicating the apartment, room or office in, at or adjacent to which a delivery point which is situated within a building is located.
     * - minOccurs: 0
     * @var \StructType\DoorType
     */
    public $Door;
    /**
     * The BuildingConstruction
     * Meta informations extracted from the WSDL
     * - documentation: S42 name: Building/Construction Level 1, code: 30.26.1.0.0, Element identifying the "number" or "name and type" of the building, unit or construction in or adjacent to which a delivery point is located. E.g. Batiment A, Block 7,
     * Houseboat, London Tower, ...
     * - minOccurs: 0
     * @var string
     */
    public $BuildingConstruction;
    /**
     * Constructor method for StructuredMailRecipientDispatchingInformationType
     * @uses StructuredMailRecipientDispatchingInformationType::setWing()
     * @uses StructuredMailRecipientDispatchingInformationType::setStairwell()
     * @uses StructuredMailRecipientDispatchingInformationType::setFloor()
     * @uses StructuredMailRecipientDispatchingInformationType::setDoor()
     * @uses StructuredMailRecipientDispatchingInformationType::setBuildingConstruction()
     * @param \StructType\WingType $wing
     * @param \StructType\StairwellType $stairwell
     * @param \StructType\FloorType $floor
     * @param \StructType\DoorType $door
     * @param string $buildingConstruction
     */
    public function __construct(\StructType\WingType $wing = null, \StructType\StairwellType $stairwell = null, \StructType\FloorType $floor = null, \StructType\DoorType $door = null, $buildingConstruction = null)
    {
        $this
            ->setWing($wing)
            ->setStairwell($stairwell)
            ->setFloor($floor)
            ->setDoor($door)
            ->setBuildingConstruction($buildingConstruction);
    }
    /**
     * Get Wing value
     * @return \StructType\WingType|null
     */
    public function getWing()
    {
        return $this->Wing;
    }
    /**
     * Set Wing value
     * @param \StructType\WingType $wing
     * @return \StructType\StructuredMailRecipientDispatchingInformationType
     */
    public function setWing(\StructType\WingType $wing = null)
    {
        $this->Wing = $wing;
        return $this;
    }
    /**
     * Get Stairwell value
     * @return \StructType\StairwellType|null
     */
    public function getStairwell()
    {
        return $this->Stairwell;
    }
    /**
     * Set Stairwell value
     * @param \StructType\StairwellType $stairwell
     * @return \StructType\StructuredMailRecipientDispatchingInformationType
     */
    public function setStairwell(\StructType\StairwellType $stairwell = null)
    {
        $this->Stairwell = $stairwell;
        return $this;
    }
    /**
     * Get Floor value
     * @return \StructType\FloorType|null
     */
    public function getFloor()
    {
        return $this->Floor;
    }
    /**
     * Set Floor value
     * @param \StructType\FloorType $floor
     * @return \StructType\StructuredMailRecipientDispatchingInformationType
     */
    public function setFloor(\StructType\FloorType $floor = null)
    {
        $this->Floor = $floor;
        return $this;
    }
    /**
     * Get Door value
     * @return \StructType\DoorType|null
     */
    public function getDoor()
    {
        return $this->Door;
    }
    /**
     * Set Door value
     * @param \StructType\DoorType $door
     * @return \StructType\StructuredMailRecipientDispatchingInformationType
     */
    public function setDoor(\StructType\DoorType $door = null)
    {
        $this->Door = $door;
        return $this;
    }
    /**
     * Get BuildingConstruction value
     * @return string|null
     */
    public function getBuildingConstruction()
    {
        return $this->BuildingConstruction;
    }
    /**
     * Set BuildingConstruction value
     * @param string $buildingConstruction
     * @return \StructType\StructuredMailRecipientDispatchingInformationType
     */
    public function setBuildingConstruction($buildingConstruction = null)
    {
        // validation for constraint: string
        if (!is_null($buildingConstruction) && !is_string($buildingConstruction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($buildingConstruction)), __LINE__);
        }
        $this->BuildingConstruction = $buildingConstruction;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StructuredMailRecipientDispatchingInformationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
