<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StairwellType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Element indicating access to floor or door within a building, unit or construction. E.g. escalier 1, staircase west.(UPU)
 * @subpackage Structs
 */
class StairwellType extends AbstractStructBase
{
    /**
     * The StairwellType
     * Meta informations extracted from the WSDL
     * - documentation: S42 name: Stairwell Type, code: 30.30.0.0.1
     * - minOccurs: 0
     * @var string
     */
    public $StairwellType;
    /**
     * The StairwellIndicator
     * Meta informations extracted from the WSDL
     * - documentation: S42 name: Stairwell Indicator, code: 30.30.0.0.2
     * - minOccurs: 0
     * @var string
     */
    public $StairwellIndicator;
    /**
     * Constructor method for StairwellType
     * @uses StairwellType::setStairwellType()
     * @uses StairwellType::setStairwellIndicator()
     * @param string $stairwellType
     * @param string $stairwellIndicator
     */
    public function __construct($stairwellType = null, $stairwellIndicator = null)
    {
        $this
            ->setStairwellType($stairwellType)
            ->setStairwellIndicator($stairwellIndicator);
    }
    /**
     * Get StairwellType value
     * @return string|null
     */
    public function getStairwellType()
    {
        return $this->StairwellType;
    }
    /**
     * Set StairwellType value
     * @param string $stairwellType
     * @return \StructType\StairwellType
     */
    public function setStairwellType($stairwellType = null)
    {
        // validation for constraint: string
        if (!is_null($stairwellType) && !is_string($stairwellType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stairwellType)), __LINE__);
        }
        $this->StairwellType = $stairwellType;
        return $this;
    }
    /**
     * Get StairwellIndicator value
     * @return string|null
     */
    public function getStairwellIndicator()
    {
        return $this->StairwellIndicator;
    }
    /**
     * Set StairwellIndicator value
     * @param string $stairwellIndicator
     * @return \StructType\StairwellType
     */
    public function setStairwellIndicator($stairwellIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($stairwellIndicator) && !is_string($stairwellIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stairwellIndicator)), __LINE__);
        }
        $this->StairwellIndicator = $stairwellIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StairwellType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
