<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Longitude StructType
 * @subpackage Structs
 */
class Longitude extends AbstractStructBase
{
    /**
     * The Value
     * @var string
     */
    public $Value;
    /**
     * The CoordinateType
     * Meta informations extracted from the WSDL
     * - ref: msg:CoordinateType
     * @var string
     */
    public $CoordinateType;
    /**
     * Constructor method for Longitude
     * @uses Longitude::setValue()
     * @uses Longitude::setCoordinateType()
     * @param string $value
     * @param string $coordinateType
     */
    public function __construct($value = null, $coordinateType = null)
    {
        $this
            ->setValue($value)
            ->setCoordinateType($coordinateType);
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \StructType\Longitude
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get CoordinateType value
     * @return string|null
     */
    public function getCoordinateType()
    {
        return $this->CoordinateType;
    }
    /**
     * Set CoordinateType value
     * @uses \EnumType\CoordinateTypeType::valueIsValid()
     * @uses \EnumType\CoordinateTypeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $coordinateType
     * @return \StructType\Longitude
     */
    public function setCoordinateType($coordinateType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CoordinateTypeType::valueIsValid($coordinateType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $coordinateType, implode(', ', \EnumType\CoordinateTypeType::getValidValues())), __LINE__);
        }
        $this->CoordinateType = $coordinateType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Longitude
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
