<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LabelType StructType
 * Meta informations extracted from the WSDL
 * - documentation: The label contains the formatted address structured in line elements.
 * @subpackage Structs
 */
class LabelType extends AbstractStructBase
{
    /**
     * The Line
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Line;
    /**
     * Constructor method for LabelType
     * @uses LabelType::setLine()
     * @param string[] $line
     */
    public function __construct(array $line = array())
    {
        $this
            ->setLine($line);
    }
    /**
     * Get Line value
     * @return string[]|null
     */
    public function getLine()
    {
        return $this->Line;
    }
    /**
     * Set Line value
     * @throws \InvalidArgumentException
     * @param string[] $line
     * @return \StructType\LabelType
     */
    public function setLine(array $line = array())
    {
        foreach ($line as $labelTypeLineItem) {
            // validation for constraint: itemType
            if (!is_string($labelTypeLineItem)) {
                throw new \InvalidArgumentException(sprintf('The Line property can only contain items of string, "%s" given', is_object($labelTypeLineItem) ? get_class($labelTypeLineItem) : gettype($labelTypeLineItem)), __LINE__);
            }
        }
        $this->Line = $line;
        return $this;
    }
    /**
     * Add item to Line value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\LabelType
     */
    public function addToLine($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Line property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Line[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LabelType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
