<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FloorType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Element indicating the floor or level on which a delivery point is located in a multi-story construction.(UPU)
 * @subpackage Structs
 */
class FloorType extends AbstractStructBase
{
    /**
     * The FloorType
     * Meta informations extracted from the WSDL
     * - documentation: S42 name: Floor Type, code: 30.31.0.0.1
     * - minOccurs: 0
     * @var string
     */
    public $FloorType;
    /**
     * The FloorIndicator
     * Meta informations extracted from the WSDL
     * - documentation: S42 name: Floor Indicator, code: 30.31.0.0.2
     * - minOccurs: 0
     * @var string
     */
    public $FloorIndicator;
    /**
     * Constructor method for FloorType
     * @uses FloorType::setFloorType()
     * @uses FloorType::setFloorIndicator()
     * @param string $floorType
     * @param string $floorIndicator
     */
    public function __construct($floorType = null, $floorIndicator = null)
    {
        $this
            ->setFloorType($floorType)
            ->setFloorIndicator($floorIndicator);
    }
    /**
     * Get FloorType value
     * @return string|null
     */
    public function getFloorType()
    {
        return $this->FloorType;
    }
    /**
     * Set FloorType value
     * @param string $floorType
     * @return \StructType\FloorType
     */
    public function setFloorType($floorType = null)
    {
        // validation for constraint: string
        if (!is_null($floorType) && !is_string($floorType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($floorType)), __LINE__);
        }
        $this->FloorType = $floorType;
        return $this;
    }
    /**
     * Get FloorIndicator value
     * @return string|null
     */
    public function getFloorIndicator()
    {
        return $this->FloorIndicator;
    }
    /**
     * Set FloorIndicator value
     * @param string $floorIndicator
     * @return \StructType\FloorType
     */
    public function setFloorIndicator($floorIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($floorIndicator) && !is_string($floorIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($floorIndicator)), __LINE__);
        }
        $this->FloorIndicator = $floorIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FloorType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
