<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DoorType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Address Element indicating the apartment, room or office in, at or adjacent to which a delivery point which is situated within a building is located.(UPU)
 * @subpackage Structs
 */
class DoorType extends AbstractStructBase
{
    /**
     * The DoorType
     * Meta informations extracted from the WSDL
     * - documentation: S42 name: Door Type, code: 30.32.0.0.1
     * - minOccurs: 0
     * @var string
     */
    public $DoorType;
    /**
     * The DoorIndicator
     * Meta informations extracted from the WSDL
     * - documentation: S42 name: Door Indicator, code: 30.32.0.0.2
     * - minOccurs: 0
     * @var string
     */
    public $DoorIndicator;
    /**
     * Constructor method for DoorType
     * @uses DoorType::setDoorType()
     * @uses DoorType::setDoorIndicator()
     * @param string $doorType
     * @param string $doorIndicator
     */
    public function __construct($doorType = null, $doorIndicator = null)
    {
        $this
            ->setDoorType($doorType)
            ->setDoorIndicator($doorIndicator);
    }
    /**
     * Get DoorType value
     * @return string|null
     */
    public function getDoorType()
    {
        return $this->DoorType;
    }
    /**
     * Set DoorType value
     * @param string $doorType
     * @return \StructType\DoorType
     */
    public function setDoorType($doorType = null)
    {
        // validation for constraint: string
        if (!is_null($doorType) && !is_string($doorType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($doorType)), __LINE__);
        }
        $this->DoorType = $doorType;
        return $this;
    }
    /**
     * Get DoorIndicator value
     * @return string|null
     */
    public function getDoorIndicator()
    {
        return $this->DoorIndicator;
    }
    /**
     * Set DoorIndicator value
     * @param string $doorIndicator
     * @return \StructType\DoorType
     */
    public function setDoorIndicator($doorIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($doorIndicator) && !is_string($doorIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($doorIndicator)), __LINE__);
        }
        $this->DoorIndicator = $doorIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DoorType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
