<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressToFormatList StructType
 * @subpackage Structs
 */
class AddressToFormatList extends AbstractStructBase
{
    /**
     * The AddressToFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 200
     * @var \StructType\AddressToFormatType[]
     */
    public $AddressToFormat;
    /**
     * Constructor method for AddressToFormatList
     * @uses AddressToFormatList::setAddressToFormat()
     * @param \StructType\AddressToFormatType[] $addressToFormat
     */
    public function __construct(array $addressToFormat = array())
    {
        $this
            ->setAddressToFormat($addressToFormat);
    }
    /**
     * Get AddressToFormat value
     * @return \StructType\AddressToFormatType[]|null
     */
    public function getAddressToFormat()
    {
        return $this->AddressToFormat;
    }
    /**
     * Set AddressToFormat value
     * @throws \InvalidArgumentException
     * @param \StructType\AddressToFormatType[] $addressToFormat
     * @return \StructType\AddressToFormatList
     */
    public function setAddressToFormat(array $addressToFormat = array())
    {
        foreach ($addressToFormat as $addressToFormatListAddressToFormatItem) {
            // validation for constraint: itemType
            if (!$addressToFormatListAddressToFormatItem instanceof \StructType\AddressToFormatType) {
                throw new \InvalidArgumentException(sprintf('The AddressToFormat property can only contain items of \StructType\AddressToFormatType, "%s" given', is_object($addressToFormatListAddressToFormatItem) ? get_class($addressToFormatListAddressToFormatItem) : gettype($addressToFormatListAddressToFormatItem)), __LINE__);
            }
        }
        $this->AddressToFormat = $addressToFormat;
        return $this;
    }
    /**
     * Add item to AddressToFormat value
     * @throws \InvalidArgumentException
     * @param \StructType\AddressToFormatType $item
     * @return \StructType\AddressToFormatList
     */
    public function addToAddressToFormat(\StructType\AddressToFormatType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AddressToFormatType) {
            throw new \InvalidArgumentException(sprintf('The AddressToFormat property can only contain items of \StructType\AddressToFormatType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AddressToFormat[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddressToFormatList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
