<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Provide ServiceType
 * @subpackage Services
 */
class Provide extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named provideFeedback
     * Meta informations extracted from the WSDL
     * - documentation: Offers feedback on a previously validated address.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProvideFeedbackRequestType $parameters
     * @return \StructType\ProvideFeedbackResponseType|bool
     */
    public function provideFeedback(\StructType\ProvideFeedbackRequestType $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->provideFeedback($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ProvideFeedbackResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
