<?php

namespace EnumType;

/**
 * This class stands for ResultType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Type used to standardize the terminology used to indicate whether an operation completed successfully. In case an operation fails, it should throw a fault. Can be potentially be extended with a WARNING.
 * @subpackage Enumerations
 */
class ResultType
{
    /**
     * Constant for value 'REGISTERED'
     * @return string 'REGISTERED'
     */
    const VALUE_REGISTERED = 'REGISTERED';
    /**
     * Constant for value 'SUCCESS'
     * @return string 'SUCCESS'
     */
    const VALUE_SUCCESS = 'SUCCESS';
    /**
     * Constant for value 'FAILURE'
     * @return string 'FAILURE'
     */
    const VALUE_FAILURE = 'FAILURE';
    /**
     * Constant for value 'NOT_APPLICABLE'
     * @return string 'NOT_APPLICABLE'
     */
    const VALUE_NOT_APPLICABLE = 'NOT_APPLICABLE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_REGISTERED
     * @uses self::VALUE_SUCCESS
     * @uses self::VALUE_FAILURE
     * @uses self::VALUE_NOT_APPLICABLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REGISTERED,
            self::VALUE_SUCCESS,
            self::VALUE_FAILURE,
            self::VALUE_NOT_APPLICABLE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
