<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StructuredDeliveryPointLocationComplexType StructType
 * @subpackage Structs
 */
class StructuredDeliveryPointLocationComplexType extends AbstractStructBase
{
    /**
     * The StreetName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StreetName;
    /**
     * The StreetNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StreetNumber;
    /**
     * The BoxNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BoxNumber;
    /**
     * Constructor method for StructuredDeliveryPointLocationComplexType
     * @uses StructuredDeliveryPointLocationComplexType::setStreetName()
     * @uses StructuredDeliveryPointLocationComplexType::setStreetNumber()
     * @uses StructuredDeliveryPointLocationComplexType::setBoxNumber()
     * @param string $streetName
     * @param string $streetNumber
     * @param string $boxNumber
     */
    public function __construct($streetName = null, $streetNumber = null, $boxNumber = null)
    {
        $this
            ->setStreetName($streetName)
            ->setStreetNumber($streetNumber)
            ->setBoxNumber($boxNumber);
    }
    /**
     * Get StreetName value
     * @return string|null
     */
    public function getStreetName()
    {
        return $this->StreetName;
    }
    /**
     * Set StreetName value
     * @param string $streetName
     * @return \StructType\StructuredDeliveryPointLocationComplexType
     */
    public function setStreetName($streetName = null)
    {
        // validation for constraint: string
        if (!is_null($streetName) && !is_string($streetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streetName)), __LINE__);
        }
        $this->StreetName = $streetName;
        return $this;
    }
    /**
     * Get StreetNumber value
     * @return string|null
     */
    public function getStreetNumber()
    {
        return $this->StreetNumber;
    }
    /**
     * Set StreetNumber value
     * @param string $streetNumber
     * @return \StructType\StructuredDeliveryPointLocationComplexType
     */
    public function setStreetNumber($streetNumber = null)
    {
        // validation for constraint: string
        if (!is_null($streetNumber) && !is_string($streetNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streetNumber)), __LINE__);
        }
        $this->StreetNumber = $streetNumber;
        return $this;
    }
    /**
     * Get BoxNumber value
     * @return string|null
     */
    public function getBoxNumber()
    {
        return $this->BoxNumber;
    }
    /**
     * Set BoxNumber value
     * @param string $boxNumber
     * @return \StructType\StructuredDeliveryPointLocationComplexType
     */
    public function setBoxNumber($boxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($boxNumber) && !is_string($boxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($boxNumber)), __LINE__);
        }
        $this->BoxNumber = $boxNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StructuredDeliveryPointLocationComplexType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
