<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostalAddressType StructType
 * @subpackage Structs
 */
class PostalAddressType extends AbstractStructBase
{
    /**
     * The OtherDeliveryInformation
     * Meta informations extracted from the WSDL
     * - documentation: PO Box Number or bpack 24/7 name
     * - minOccurs: 0
     * @var \StructType\OtherDeliveryInformationComplexType
     */
    public $OtherDeliveryInformation;
    /**
     * The DeliveryPointLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DeliveryPointLocationComplexType
     */
    public $DeliveryPointLocation;
    /**
     * The PostalCodeMunicipality
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PostalCodeMunicipalityComplexType
     */
    public $PostalCodeMunicipality;
    /**
     * The CountryName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: msg:CountryName
     * @var mixed
     */
    public $CountryName;
    /**
     * Constructor method for PostalAddressType
     * @uses PostalAddressType::setOtherDeliveryInformation()
     * @uses PostalAddressType::setDeliveryPointLocation()
     * @uses PostalAddressType::setPostalCodeMunicipality()
     * @uses PostalAddressType::setCountryName()
     * @param \StructType\OtherDeliveryInformationComplexType $otherDeliveryInformation
     * @param \StructType\DeliveryPointLocationComplexType $deliveryPointLocation
     * @param \StructType\PostalCodeMunicipalityComplexType $postalCodeMunicipality
     * @param mixed $countryName
     */
    public function __construct(\StructType\OtherDeliveryInformationComplexType $otherDeliveryInformation = null, \StructType\DeliveryPointLocationComplexType $deliveryPointLocation = null, \StructType\PostalCodeMunicipalityComplexType $postalCodeMunicipality = null, $countryName = null)
    {
        $this
            ->setOtherDeliveryInformation($otherDeliveryInformation)
            ->setDeliveryPointLocation($deliveryPointLocation)
            ->setPostalCodeMunicipality($postalCodeMunicipality)
            ->setCountryName($countryName);
    }
    /**
     * Get OtherDeliveryInformation value
     * @return \StructType\OtherDeliveryInformationComplexType|null
     */
    public function getOtherDeliveryInformation()
    {
        return $this->OtherDeliveryInformation;
    }
    /**
     * Set OtherDeliveryInformation value
     * @param \StructType\OtherDeliveryInformationComplexType $otherDeliveryInformation
     * @return \StructType\PostalAddressType
     */
    public function setOtherDeliveryInformation(\StructType\OtherDeliveryInformationComplexType $otherDeliveryInformation = null)
    {
        $this->OtherDeliveryInformation = $otherDeliveryInformation;
        return $this;
    }
    /**
     * Get DeliveryPointLocation value
     * @return \StructType\DeliveryPointLocationComplexType|null
     */
    public function getDeliveryPointLocation()
    {
        return $this->DeliveryPointLocation;
    }
    /**
     * Set DeliveryPointLocation value
     * @param \StructType\DeliveryPointLocationComplexType $deliveryPointLocation
     * @return \StructType\PostalAddressType
     */
    public function setDeliveryPointLocation(\StructType\DeliveryPointLocationComplexType $deliveryPointLocation = null)
    {
        $this->DeliveryPointLocation = $deliveryPointLocation;
        return $this;
    }
    /**
     * Get PostalCodeMunicipality value
     * @return \StructType\PostalCodeMunicipalityComplexType|null
     */
    public function getPostalCodeMunicipality()
    {
        return $this->PostalCodeMunicipality;
    }
    /**
     * Set PostalCodeMunicipality value
     * @param \StructType\PostalCodeMunicipalityComplexType $postalCodeMunicipality
     * @return \StructType\PostalAddressType
     */
    public function setPostalCodeMunicipality(\StructType\PostalCodeMunicipalityComplexType $postalCodeMunicipality = null)
    {
        $this->PostalCodeMunicipality = $postalCodeMunicipality;
        return $this;
    }
    /**
     * Get CountryName value
     * @return mixed|null
     */
    public function getCountryName()
    {
        return $this->CountryName;
    }
    /**
     * Set CountryName value
     * @param mixed $countryName
     * @return \StructType\PostalAddressType
     */
    public function setCountryName($countryName = null)
    {
        $this->CountryName = $countryName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PostalAddressType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
