<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeographicalLocationType StructType
 * @subpackage Structs
 */
class GeographicalLocationType extends AbstractStructBase
{
    /**
     * The Latitude
     * Meta informations extracted from the WSDL
     * - ref: msg:Latitude
     * @var \StructType\Latitude
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta informations extracted from the WSDL
     * - ref: msg:Longitude
     * @var \StructType\Longitude
     */
    public $Longitude;
    /**
     * The Elevation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: msg:Elevation
     * @var \StructType\DimensionType
     */
    public $Elevation;
    /**
     * Constructor method for GeographicalLocationType
     * @uses GeographicalLocationType::setLatitude()
     * @uses GeographicalLocationType::setLongitude()
     * @uses GeographicalLocationType::setElevation()
     * @param \StructType\Latitude $latitude
     * @param \StructType\Longitude $longitude
     * @param \StructType\DimensionType $elevation
     */
    public function __construct(\StructType\Latitude $latitude = null, \StructType\Longitude $longitude = null, \StructType\DimensionType $elevation = null)
    {
        $this
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setElevation($elevation);
    }
    /**
     * Get Latitude value
     * @return \StructType\Latitude|null
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param \StructType\Latitude $latitude
     * @return \StructType\GeographicalLocationType
     */
    public function setLatitude(\StructType\Latitude $latitude = null)
    {
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return \StructType\Longitude|null
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param \StructType\Longitude $longitude
     * @return \StructType\GeographicalLocationType
     */
    public function setLongitude(\StructType\Longitude $longitude = null)
    {
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get Elevation value
     * @return \StructType\DimensionType|null
     */
    public function getElevation()
    {
        return $this->Elevation;
    }
    /**
     * Set Elevation value
     * @param \StructType\DimensionType $elevation
     * @return \StructType\GeographicalLocationType
     */
    public function setElevation(\StructType\DimensionType $elevation = null)
    {
        $this->Elevation = $elevation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GeographicalLocationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
