<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DimensionType StructType
 * Meta informations extracted from the WSDL
 * - documentation: The type representing the dimension of an object in terms of a quantity and a unit of dimension.
 * @subpackage Structs
 */
class DimensionType extends AbstractStructBase
{
    /**
     * The Quantity
     * @var float
     */
    public $Quantity;
    /**
     * The UnitOfDimension
     * @var string
     */
    public $UnitOfDimension;
    /**
     * Constructor method for DimensionType
     * @uses DimensionType::setQuantity()
     * @uses DimensionType::setUnitOfDimension()
     * @param float $quantity
     * @param string $unitOfDimension
     */
    public function __construct($quantity = null, $unitOfDimension = null)
    {
        $this
            ->setQuantity($quantity)
            ->setUnitOfDimension($unitOfDimension);
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\DimensionType
     */
    public function setQuantity($quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get UnitOfDimension value
     * @return string|null
     */
    public function getUnitOfDimension()
    {
        return $this->UnitOfDimension;
    }
    /**
     * Set UnitOfDimension value
     * @uses \EnumType\UnitOfDimensionType::valueIsValid()
     * @uses \EnumType\UnitOfDimensionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unitOfDimension
     * @return \StructType\DimensionType
     */
    public function setUnitOfDimension($unitOfDimension = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UnitOfDimensionType::valueIsValid($unitOfDimension)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $unitOfDimension, implode(', ', \EnumType\UnitOfDimensionType::getValidValues())), __LINE__);
        }
        $this->UnitOfDimension = $unitOfDimension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DimensionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
