<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CallerIdentificationType StructType
 * Meta informations extracted from the WSDL
 * - documentation: The caller can be identified with a caller name (in case the service is called by a person).
 * @subpackage Structs
 */
class CallerIdentificationType extends AbstractStructBase
{
    /**
     * The CallerName
     * @var string
     */
    public $CallerName;
    /**
     * Constructor method for CallerIdentificationType
     * @uses CallerIdentificationType::setCallerName()
     * @param string $callerName
     */
    public function __construct($callerName = null)
    {
        $this
            ->setCallerName($callerName);
    }
    /**
     * Get CallerName value
     * @return string|null
     */
    public function getCallerName()
    {
        return $this->CallerName;
    }
    /**
     * Set CallerName value
     * @param string $callerName
     * @return \StructType\CallerIdentificationType
     */
    public function setCallerName($callerName = null)
    {
        // validation for constraint: string
        if (!is_null($callerName) && !is_string($callerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callerName)), __LINE__);
        }
        $this->CallerName = $callerName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CallerIdentificationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
