<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressBlockLinesType StructType
 * @subpackage Structs
 */
class AddressBlockLinesType extends AbstractStructBase
{
    /**
     * The UnstructuredAddressLine
     * Meta informations extracted from the WSDL
     * - maxOccurs: 7
     * - minOccurs: 0
     * - ref: msg:UnstructuredAddressLine
     * @var \StructType\LocalizedStringType[]
     */
    public $UnstructuredAddressLine;
    /**
     * Constructor method for AddressBlockLinesType
     * @uses AddressBlockLinesType::setUnstructuredAddressLine()
     * @param \StructType\LocalizedStringType[] $unstructuredAddressLine
     */
    public function __construct(array $unstructuredAddressLine = array())
    {
        $this
            ->setUnstructuredAddressLine($unstructuredAddressLine);
    }
    /**
     * Get UnstructuredAddressLine value
     * @return \StructType\LocalizedStringType[]|null
     */
    public function getUnstructuredAddressLine()
    {
        return $this->UnstructuredAddressLine;
    }
    /**
     * Set UnstructuredAddressLine value
     * @throws \InvalidArgumentException
     * @param \StructType\LocalizedStringType[] $unstructuredAddressLine
     * @return \StructType\AddressBlockLinesType
     */
    public function setUnstructuredAddressLine(array $unstructuredAddressLine = array())
    {
        foreach ($unstructuredAddressLine as $addressBlockLinesTypeUnstructuredAddressLineItem) {
            // validation for constraint: itemType
            if (!$addressBlockLinesTypeUnstructuredAddressLineItem instanceof \StructType\LocalizedStringType) {
                throw new \InvalidArgumentException(sprintf('The UnstructuredAddressLine property can only contain items of \StructType\LocalizedStringType, "%s" given', is_object($addressBlockLinesTypeUnstructuredAddressLineItem) ? get_class($addressBlockLinesTypeUnstructuredAddressLineItem) : gettype($addressBlockLinesTypeUnstructuredAddressLineItem)), __LINE__);
            }
        }
        $this->UnstructuredAddressLine = $unstructuredAddressLine;
        return $this;
    }
    /**
     * Add item to UnstructuredAddressLine value
     * @throws \InvalidArgumentException
     * @param \StructType\LocalizedStringType $item
     * @return \StructType\AddressBlockLinesType
     */
    public function addToUnstructuredAddressLine(\StructType\LocalizedStringType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LocalizedStringType) {
            throw new \InvalidArgumentException(sprintf('The UnstructuredAddressLine property can only contain items of \StructType\LocalizedStringType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UnstructuredAddressLine[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddressBlockLinesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
