<?php

namespace EnumType;

/**
 * This class stands for UnitOfDimensionType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: The type representing the different units of dimension of an object.
 * @subpackage Enumerations
 */
class UnitOfDimensionType
{
    /**
     * Constant for value 'km'
     * @return string 'km'
     */
    const VALUE_KM = 'km';
    /**
     * Constant for value 'm'
     * @return string 'm'
     */
    const VALUE_M = 'm';
    /**
     * Constant for value 'mm'
     * @return string 'mm'
     */
    const VALUE_MM = 'mm';
    /**
     * Constant for value 'MILE'
     * @return string 'MILE'
     */
    const VALUE_MILE = 'MILE';
    /**
     * Constant for value 'YARD'
     * @return string 'YARD'
     */
    const VALUE_YARD = 'YARD';
    /**
     * Constant for value 'INCH'
     * @return string 'INCH'
     */
    const VALUE_INCH = 'INCH';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KM
     * @uses self::VALUE_M
     * @uses self::VALUE_MM
     * @uses self::VALUE_MILE
     * @uses self::VALUE_YARD
     * @uses self::VALUE_INCH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KM,
            self::VALUE_M,
            self::VALUE_MM,
            self::VALUE_MILE,
            self::VALUE_YARD,
            self::VALUE_INCH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
