<?php

namespace EnumType;

/**
 * This class stands for LanguageCodeType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Restricted list of language types, supported by bpost
 * @subpackage Enumerations
 */
class LanguageCodeType
{
    /**
     * Constant for value 'nl'
     * @return string 'nl'
     */
    const VALUE_NL = 'nl';
    /**
     * Constant for value 'fr'
     * @return string 'fr'
     */
    const VALUE_FR = 'fr';
    /**
     * Constant for value 'en'
     * @return string 'en'
     */
    const VALUE_EN = 'en';
    /**
     * Constant for value 'de'
     * @return string 'de'
     */
    const VALUE_DE = 'de';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NL
     * @uses self::VALUE_FR
     * @uses self::VALUE_EN
     * @uses self::VALUE_DE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NL,
            self::VALUE_FR,
            self::VALUE_EN,
            self::VALUE_DE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
