<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ZmenaPolIn StructType
 * @subpackage Structs
 */
class ZmenaPolIn extends AbstractStructBase
{
    /**
     * The CisloSmlouvy
     * @var string
     */
    public $CisloSmlouvy;
    /**
     * The CisloTP
     * @var string
     */
    public $CisloTP;
    /**
     * The DatumZmeny
     * @var int
     */
    public $DatumZmeny;
    /**
     * The PoradiVozidla
     * @var int
     */
    public $PoradiVozidla;
    /**
     * The SPZ
     * @var string
     */
    public $SPZ;
    /**
     * Constructor method for ZmenaPolIn
     * @uses ZmenaPolIn::setCisloSmlouvy()
     * @uses ZmenaPolIn::setCisloTP()
     * @uses ZmenaPolIn::setDatumZmeny()
     * @uses ZmenaPolIn::setPoradiVozidla()
     * @uses ZmenaPolIn::setSPZ()
     * @param string $cisloSmlouvy
     * @param string $cisloTP
     * @param int $datumZmeny
     * @param int $poradiVozidla
     * @param string $sPZ
     */
    public function __construct($cisloSmlouvy = null, $cisloTP = null, $datumZmeny = null, $poradiVozidla = null, $sPZ = null)
    {
        $this
            ->setCisloSmlouvy($cisloSmlouvy)
            ->setCisloTP($cisloTP)
            ->setDatumZmeny($datumZmeny)
            ->setPoradiVozidla($poradiVozidla)
            ->setSPZ($sPZ);
    }
    /**
     * Get CisloSmlouvy value
     * @return string|null
     */
    public function getCisloSmlouvy()
    {
        return $this->CisloSmlouvy;
    }
    /**
     * Set CisloSmlouvy value
     * @param string $cisloSmlouvy
     * @return \StructType\ZmenaPolIn
     */
    public function setCisloSmlouvy($cisloSmlouvy = null)
    {
        // validation for constraint: string
        if (!is_null($cisloSmlouvy) && !is_string($cisloSmlouvy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cisloSmlouvy)), __LINE__);
        }
        $this->CisloSmlouvy = $cisloSmlouvy;
        return $this;
    }
    /**
     * Get CisloTP value
     * @return string|null
     */
    public function getCisloTP()
    {
        return $this->CisloTP;
    }
    /**
     * Set CisloTP value
     * @param string $cisloTP
     * @return \StructType\ZmenaPolIn
     */
    public function setCisloTP($cisloTP = null)
    {
        // validation for constraint: string
        if (!is_null($cisloTP) && !is_string($cisloTP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cisloTP)), __LINE__);
        }
        $this->CisloTP = $cisloTP;
        return $this;
    }
    /**
     * Get DatumZmeny value
     * @return int|null
     */
    public function getDatumZmeny()
    {
        return $this->DatumZmeny;
    }
    /**
     * Set DatumZmeny value
     * @param int $datumZmeny
     * @return \StructType\ZmenaPolIn
     */
    public function setDatumZmeny($datumZmeny = null)
    {
        // validation for constraint: int
        if (!is_null($datumZmeny) && !is_numeric($datumZmeny)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($datumZmeny)), __LINE__);
        }
        $this->DatumZmeny = $datumZmeny;
        return $this;
    }
    /**
     * Get PoradiVozidla value
     * @return int|null
     */
    public function getPoradiVozidla()
    {
        return $this->PoradiVozidla;
    }
    /**
     * Set PoradiVozidla value
     * @param int $poradiVozidla
     * @return \StructType\ZmenaPolIn
     */
    public function setPoradiVozidla($poradiVozidla = null)
    {
        // validation for constraint: int
        if (!is_null($poradiVozidla) && !is_numeric($poradiVozidla)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($poradiVozidla)), __LINE__);
        }
        $this->PoradiVozidla = $poradiVozidla;
        return $this;
    }
    /**
     * Get SPZ value
     * @return string|null
     */
    public function getSPZ()
    {
        return $this->SPZ;
    }
    /**
     * Set SPZ value
     * @param string $sPZ
     * @return \StructType\ZmenaPolIn
     */
    public function setSPZ($sPZ = null)
    {
        // validation for constraint: string
        if (!is_null($sPZ) && !is_string($sPZ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sPZ)), __LINE__);
        }
        $this->SPZ = $sPZ;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ZmenaPolIn
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
