<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Pojistne StructType
 * @subpackage Structs
 */
class Pojistne extends AbstractStructBase
{
    /**
     * The LhutniPojistne
     * @var int
     */
    public $LhutniPojistne;
    /**
     * The RocniPojistne
     * @var int
     */
    public $RocniPojistne;
    /**
     * Constructor method for Pojistne
     * @uses Pojistne::setLhutniPojistne()
     * @uses Pojistne::setRocniPojistne()
     * @param int $lhutniPojistne
     * @param int $rocniPojistne
     */
    public function __construct($lhutniPojistne = null, $rocniPojistne = null)
    {
        $this
            ->setLhutniPojistne($lhutniPojistne)
            ->setRocniPojistne($rocniPojistne);
    }
    /**
     * Get LhutniPojistne value
     * @return int|null
     */
    public function getLhutniPojistne()
    {
        return $this->LhutniPojistne;
    }
    /**
     * Set LhutniPojistne value
     * @param int $lhutniPojistne
     * @return \StructType\Pojistne
     */
    public function setLhutniPojistne($lhutniPojistne = null)
    {
        // validation for constraint: int
        if (!is_null($lhutniPojistne) && !is_numeric($lhutniPojistne)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lhutniPojistne)), __LINE__);
        }
        $this->LhutniPojistne = $lhutniPojistne;
        return $this;
    }
    /**
     * Get RocniPojistne value
     * @return int|null
     */
    public function getRocniPojistne()
    {
        return $this->RocniPojistne;
    }
    /**
     * Set RocniPojistne value
     * @param int $rocniPojistne
     * @return \StructType\Pojistne
     */
    public function setRocniPojistne($rocniPojistne = null)
    {
        // validation for constraint: int
        if (!is_null($rocniPojistne) && !is_numeric($rocniPojistne)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rocniPojistne)), __LINE__);
        }
        $this->RocniPojistne = $rocniPojistne;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Pojistne
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
