<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlatbaIn StructType
 * @subpackage Structs
 */
class PlatbaIn extends AbstractStructBase
{
    /**
     * The Castka
     * @var int
     */
    public $Castka;
    /**
     * The CisloSmlouvy
     * @var string
     */
    public $CisloSmlouvy;
    /**
     * The LhutniPoj
     * @var int
     */
    public $LhutniPoj;
    /**
     * The Provize
     * @var int
     */
    public $Provize;
    /**
     * Constructor method for PlatbaIn
     * @uses PlatbaIn::setCastka()
     * @uses PlatbaIn::setCisloSmlouvy()
     * @uses PlatbaIn::setLhutniPoj()
     * @uses PlatbaIn::setProvize()
     * @param int $castka
     * @param string $cisloSmlouvy
     * @param int $lhutniPoj
     * @param int $provize
     */
    public function __construct($castka = null, $cisloSmlouvy = null, $lhutniPoj = null, $provize = null)
    {
        $this
            ->setCastka($castka)
            ->setCisloSmlouvy($cisloSmlouvy)
            ->setLhutniPoj($lhutniPoj)
            ->setProvize($provize);
    }
    /**
     * Get Castka value
     * @return int|null
     */
    public function getCastka()
    {
        return $this->Castka;
    }
    /**
     * Set Castka value
     * @param int $castka
     * @return \StructType\PlatbaIn
     */
    public function setCastka($castka = null)
    {
        // validation for constraint: int
        if (!is_null($castka) && !is_numeric($castka)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($castka)), __LINE__);
        }
        $this->Castka = $castka;
        return $this;
    }
    /**
     * Get CisloSmlouvy value
     * @return string|null
     */
    public function getCisloSmlouvy()
    {
        return $this->CisloSmlouvy;
    }
    /**
     * Set CisloSmlouvy value
     * @param string $cisloSmlouvy
     * @return \StructType\PlatbaIn
     */
    public function setCisloSmlouvy($cisloSmlouvy = null)
    {
        // validation for constraint: string
        if (!is_null($cisloSmlouvy) && !is_string($cisloSmlouvy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cisloSmlouvy)), __LINE__);
        }
        $this->CisloSmlouvy = $cisloSmlouvy;
        return $this;
    }
    /**
     * Get LhutniPoj value
     * @return int|null
     */
    public function getLhutniPoj()
    {
        return $this->LhutniPoj;
    }
    /**
     * Set LhutniPoj value
     * @param int $lhutniPoj
     * @return \StructType\PlatbaIn
     */
    public function setLhutniPoj($lhutniPoj = null)
    {
        // validation for constraint: int
        if (!is_null($lhutniPoj) && !is_numeric($lhutniPoj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lhutniPoj)), __LINE__);
        }
        $this->LhutniPoj = $lhutniPoj;
        return $this;
    }
    /**
     * Get Provize value
     * @return int|null
     */
    public function getProvize()
    {
        return $this->Provize;
    }
    /**
     * Set Provize value
     * @param int $provize
     * @return \StructType\PlatbaIn
     */
    public function setProvize($provize = null)
    {
        // validation for constraint: int
        if (!is_null($provize) && !is_numeric($provize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($provize)), __LINE__);
        }
        $this->Provize = $provize;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PlatbaIn
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
