<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OutNS StructType
 * @subpackage Structs
 */
class OutNS extends AbstractStructBase
{
    /**
     * The CenyPoj
     * Meta informations extracted from the WSDL
     * - arrayType: tns:CenyPoj[]
     * - ref: SOAP-ENC:arrayType
     * @var \StructType\CenyPoj[]
     */
    public $CenyPoj;
    /**
     * The Chyby
     * Meta informations extracted from the WSDL
     * - arrayType: tns:Chyby[]
     * - ref: SOAP-ENC:arrayType
     * @var \StructType\Chyby[]
     */
    public $Chyby;
    /**
     * The CisloSmlouvy
     * @var string
     */
    public $CisloSmlouvy;
    /**
     * The IDRelace
     * @var string
     */
    public $IDRelace;
    /**
     * The KontrolaKlienta
     * @var string
     */
    public $KontrolaKlienta;
    /**
     * The Pojistne
     * @var \StructType\Pojistne
     */
    public $Pojistne;
    /**
     * The RozhodnaDobaORK
     * @var int
     */
    public $RozhodnaDobaORK;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The URLDoc
     * @var string
     */
    public $URLDoc;
    /**
     * Constructor method for OutNS
     * @uses OutNS::setCenyPoj()
     * @uses OutNS::setChyby()
     * @uses OutNS::setCisloSmlouvy()
     * @uses OutNS::setIDRelace()
     * @uses OutNS::setKontrolaKlienta()
     * @uses OutNS::setPojistne()
     * @uses OutNS::setRozhodnaDobaORK()
     * @uses OutNS::setStatus()
     * @uses OutNS::setURLDoc()
     * @param \StructType\CenyPoj[] $cenyPoj
     * @param \StructType\Chyby[] $chyby
     * @param string $cisloSmlouvy
     * @param string $iDRelace
     * @param string $kontrolaKlienta
     * @param \StructType\Pojistne $pojistne
     * @param int $rozhodnaDobaORK
     * @param string $status
     * @param string $uRLDoc
     */
    public function __construct(array $cenyPoj = array(), array $chyby = array(), $cisloSmlouvy = null, $iDRelace = null, $kontrolaKlienta = null, \StructType\Pojistne $pojistne = null, $rozhodnaDobaORK = null, $status = null, $uRLDoc = null)
    {
        $this
            ->setCenyPoj($cenyPoj)
            ->setChyby($chyby)
            ->setCisloSmlouvy($cisloSmlouvy)
            ->setIDRelace($iDRelace)
            ->setKontrolaKlienta($kontrolaKlienta)
            ->setPojistne($pojistne)
            ->setRozhodnaDobaORK($rozhodnaDobaORK)
            ->setStatus($status)
            ->setURLDoc($uRLDoc);
    }
    /**
     * Get CenyPoj value
     * @return \StructType\CenyPoj[]|null
     */
    public function getCenyPoj()
    {
        return $this->CenyPoj;
    }
    /**
     * Set CenyPoj value
     * @throws \InvalidArgumentException
     * @param \StructType\CenyPoj[] $cenyPoj
     * @return \StructType\OutNS
     */
    public function setCenyPoj(array $cenyPoj = array())
    {
        foreach ($cenyPoj as $outNSCenyPojItem) {
            // validation for constraint: itemType
            if (!$outNSCenyPojItem instanceof \StructType\CenyPoj) {
                throw new \InvalidArgumentException(sprintf('The CenyPoj property can only contain items of \StructType\CenyPoj, "%s" given', is_object($outNSCenyPojItem) ? get_class($outNSCenyPojItem) : gettype($outNSCenyPojItem)), __LINE__);
            }
        }
        $this->CenyPoj = $cenyPoj;
        return $this;
    }
    /**
     * Add item to CenyPoj value
     * @throws \InvalidArgumentException
     * @param \StructType\CenyPoj $item
     * @return \StructType\OutNS
     */
    public function addToCenyPoj(\StructType\CenyPoj $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CenyPoj) {
            throw new \InvalidArgumentException(sprintf('The CenyPoj property can only contain items of \StructType\CenyPoj, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CenyPoj[] = $item;
        return $this;
    }
    /**
     * Get Chyby value
     * @return \StructType\Chyby[]|null
     */
    public function getChyby()
    {
        return $this->Chyby;
    }
    /**
     * Set Chyby value
     * @throws \InvalidArgumentException
     * @param \StructType\Chyby[] $chyby
     * @return \StructType\OutNS
     */
    public function setChyby(array $chyby = array())
    {
        foreach ($chyby as $outNSChybyItem) {
            // validation for constraint: itemType
            if (!$outNSChybyItem instanceof \StructType\Chyby) {
                throw new \InvalidArgumentException(sprintf('The Chyby property can only contain items of \StructType\Chyby, "%s" given', is_object($outNSChybyItem) ? get_class($outNSChybyItem) : gettype($outNSChybyItem)), __LINE__);
            }
        }
        $this->Chyby = $chyby;
        return $this;
    }
    /**
     * Add item to Chyby value
     * @throws \InvalidArgumentException
     * @param \StructType\Chyby $item
     * @return \StructType\OutNS
     */
    public function addToChyby(\StructType\Chyby $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Chyby) {
            throw new \InvalidArgumentException(sprintf('The Chyby property can only contain items of \StructType\Chyby, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Chyby[] = $item;
        return $this;
    }
    /**
     * Get CisloSmlouvy value
     * @return string|null
     */
    public function getCisloSmlouvy()
    {
        return $this->CisloSmlouvy;
    }
    /**
     * Set CisloSmlouvy value
     * @param string $cisloSmlouvy
     * @return \StructType\OutNS
     */
    public function setCisloSmlouvy($cisloSmlouvy = null)
    {
        // validation for constraint: string
        if (!is_null($cisloSmlouvy) && !is_string($cisloSmlouvy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cisloSmlouvy)), __LINE__);
        }
        $this->CisloSmlouvy = $cisloSmlouvy;
        return $this;
    }
    /**
     * Get IDRelace value
     * @return string|null
     */
    public function getIDRelace()
    {
        return $this->IDRelace;
    }
    /**
     * Set IDRelace value
     * @param string $iDRelace
     * @return \StructType\OutNS
     */
    public function setIDRelace($iDRelace = null)
    {
        // validation for constraint: string
        if (!is_null($iDRelace) && !is_string($iDRelace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDRelace)), __LINE__);
        }
        $this->IDRelace = $iDRelace;
        return $this;
    }
    /**
     * Get KontrolaKlienta value
     * @return string|null
     */
    public function getKontrolaKlienta()
    {
        return $this->KontrolaKlienta;
    }
    /**
     * Set KontrolaKlienta value
     * @param string $kontrolaKlienta
     * @return \StructType\OutNS
     */
    public function setKontrolaKlienta($kontrolaKlienta = null)
    {
        // validation for constraint: string
        if (!is_null($kontrolaKlienta) && !is_string($kontrolaKlienta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kontrolaKlienta)), __LINE__);
        }
        $this->KontrolaKlienta = $kontrolaKlienta;
        return $this;
    }
    /**
     * Get Pojistne value
     * @return \StructType\Pojistne|null
     */
    public function getPojistne()
    {
        return $this->Pojistne;
    }
    /**
     * Set Pojistne value
     * @param \StructType\Pojistne $pojistne
     * @return \StructType\OutNS
     */
    public function setPojistne(\StructType\Pojistne $pojistne = null)
    {
        $this->Pojistne = $pojistne;
        return $this;
    }
    /**
     * Get RozhodnaDobaORK value
     * @return int|null
     */
    public function getRozhodnaDobaORK()
    {
        return $this->RozhodnaDobaORK;
    }
    /**
     * Set RozhodnaDobaORK value
     * @param int $rozhodnaDobaORK
     * @return \StructType\OutNS
     */
    public function setRozhodnaDobaORK($rozhodnaDobaORK = null)
    {
        // validation for constraint: int
        if (!is_null($rozhodnaDobaORK) && !is_numeric($rozhodnaDobaORK)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rozhodnaDobaORK)), __LINE__);
        }
        $this->RozhodnaDobaORK = $rozhodnaDobaORK;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\OutNS
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get URLDoc value
     * @return string|null
     */
    public function getURLDoc()
    {
        return $this->URLDoc;
    }
    /**
     * Set URLDoc value
     * @param string $uRLDoc
     * @return \StructType\OutNS
     */
    public function setURLDoc($uRLDoc = null)
    {
        // validation for constraint: string
        if (!is_null($uRLDoc) && !is_string($uRLDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uRLDoc)), __LINE__);
        }
        $this->URLDoc = $uRLDoc;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OutNS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
