<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HAV StructType
 * @subpackage Structs
 */
class HAV extends AbstractStructBase
{
    /**
     * The Cena
     * @var string
     */
    public $Cena;
    /**
     * The Prohlidka
     * @var \StructType\Prohlidka
     */
    public $Prohlidka;
    /**
     * The SlevyHAV
     * @var \StructType\SlevyHAV
     */
    public $SlevyHAV;
    /**
     * The VcetneDPH
     * @var string
     */
    public $VcetneDPH;
    /**
     * The Vinkulace
     * @var \StructType\Vinkulace
     */
    public $Vinkulace;
    /**
     * Constructor method for HAV
     * @uses HAV::setCena()
     * @uses HAV::setProhlidka()
     * @uses HAV::setSlevyHAV()
     * @uses HAV::setVcetneDPH()
     * @uses HAV::setVinkulace()
     * @param string $cena
     * @param \StructType\Prohlidka $prohlidka
     * @param \StructType\SlevyHAV $slevyHAV
     * @param string $vcetneDPH
     * @param \StructType\Vinkulace $vinkulace
     */
    public function __construct($cena = null, \StructType\Prohlidka $prohlidka = null, \StructType\SlevyHAV $slevyHAV = null, $vcetneDPH = null, \StructType\Vinkulace $vinkulace = null)
    {
        $this
            ->setCena($cena)
            ->setProhlidka($prohlidka)
            ->setSlevyHAV($slevyHAV)
            ->setVcetneDPH($vcetneDPH)
            ->setVinkulace($vinkulace);
    }
    /**
     * Get Cena value
     * @return string|null
     */
    public function getCena()
    {
        return $this->Cena;
    }
    /**
     * Set Cena value
     * @param string $cena
     * @return \StructType\HAV
     */
    public function setCena($cena = null)
    {
        // validation for constraint: string
        if (!is_null($cena) && !is_string($cena)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cena)), __LINE__);
        }
        $this->Cena = $cena;
        return $this;
    }
    /**
     * Get Prohlidka value
     * @return \StructType\Prohlidka|null
     */
    public function getProhlidka()
    {
        return $this->Prohlidka;
    }
    /**
     * Set Prohlidka value
     * @param \StructType\Prohlidka $prohlidka
     * @return \StructType\HAV
     */
    public function setProhlidka(\StructType\Prohlidka $prohlidka = null)
    {
        $this->Prohlidka = $prohlidka;
        return $this;
    }
    /**
     * Get SlevyHAV value
     * @return \StructType\SlevyHAV|null
     */
    public function getSlevyHAV()
    {
        return $this->SlevyHAV;
    }
    /**
     * Set SlevyHAV value
     * @param \StructType\SlevyHAV $slevyHAV
     * @return \StructType\HAV
     */
    public function setSlevyHAV(\StructType\SlevyHAV $slevyHAV = null)
    {
        $this->SlevyHAV = $slevyHAV;
        return $this;
    }
    /**
     * Get VcetneDPH value
     * @return string|null
     */
    public function getVcetneDPH()
    {
        return $this->VcetneDPH;
    }
    /**
     * Set VcetneDPH value
     * @param string $vcetneDPH
     * @return \StructType\HAV
     */
    public function setVcetneDPH($vcetneDPH = null)
    {
        // validation for constraint: string
        if (!is_null($vcetneDPH) && !is_string($vcetneDPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vcetneDPH)), __LINE__);
        }
        $this->VcetneDPH = $vcetneDPH;
        return $this;
    }
    /**
     * Get Vinkulace value
     * @return \StructType\Vinkulace|null
     */
    public function getVinkulace()
    {
        return $this->Vinkulace;
    }
    /**
     * Set Vinkulace value
     * @param \StructType\Vinkulace $vinkulace
     * @return \StructType\HAV
     */
    public function setVinkulace(\StructType\Vinkulace $vinkulace = null)
    {
        $this->Vinkulace = $vinkulace;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HAV
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
