<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CenyPoj StructType
 * @subpackage Structs
 */
class CenyPoj extends AbstractStructBase
{
    /**
     * The KodPojisteni
     * @var string
     */
    public $KodPojisteni;
    /**
     * The RocniPojistne
     * @var int
     */
    public $RocniPojistne;
    /**
     * Constructor method for CenyPoj
     * @uses CenyPoj::setKodPojisteni()
     * @uses CenyPoj::setRocniPojistne()
     * @param string $kodPojisteni
     * @param int $rocniPojistne
     */
    public function __construct($kodPojisteni = null, $rocniPojistne = null)
    {
        $this
            ->setKodPojisteni($kodPojisteni)
            ->setRocniPojistne($rocniPojistne);
    }
    /**
     * Get KodPojisteni value
     * @return string|null
     */
    public function getKodPojisteni()
    {
        return $this->KodPojisteni;
    }
    /**
     * Set KodPojisteni value
     * @param string $kodPojisteni
     * @return \StructType\CenyPoj
     */
    public function setKodPojisteni($kodPojisteni = null)
    {
        // validation for constraint: string
        if (!is_null($kodPojisteni) && !is_string($kodPojisteni)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kodPojisteni)), __LINE__);
        }
        $this->KodPojisteni = $kodPojisteni;
        return $this;
    }
    /**
     * Get RocniPojistne value
     * @return int|null
     */
    public function getRocniPojistne()
    {
        return $this->RocniPojistne;
    }
    /**
     * Set RocniPojistne value
     * @param int $rocniPojistne
     * @return \StructType\CenyPoj
     */
    public function setRocniPojistne($rocniPojistne = null)
    {
        // validation for constraint: int
        if (!is_null($rocniPojistne) && !is_numeric($rocniPojistne)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rocniPojistne)), __LINE__);
        }
        $this->RocniPojistne = $rocniPojistne;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CenyPoj
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
