<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Zmena ServiceType
 * @subpackage Services
 */
class Zmena extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ZmenaPS
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Smlouva $smlouva
     * @return \StructType\OutNS|bool
     */
    public function ZmenaPS(\StructType\Smlouva $smlouva)
    {
        try {
            $this->setResult(self::getSoapClient()->ZmenaPS($smlouva));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ZmenaPolPS
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ZmenaPolIn $zmenaPolIn
     * @return \StructType\OutNS|bool
     */
    public function ZmenaPolPS(\StructType\ZmenaPolIn $zmenaPolIn)
    {
        try {
            $this->setResult(self::getSoapClient()->ZmenaPolPS($zmenaPolIn));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OutNS
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
