<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Storno ServiceType
 * @subpackage Services
 */
class Storno extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named StornoPS
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\StornoIn $stornoIn
     * @return \StructType\OutNS|bool
     */
    public function StornoPS(\StructType\StornoIn $stornoIn)
    {
        try {
            $this->setResult(self::getSoapClient()->StornoPS($stornoIn));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OutNS
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
