<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Vinkulace StructType
 * @subpackage Structs
 */
class Vinkulace extends AbstractStructBase
{
    /**
     * The KodBanky
     * @var int
     */
    public $KodBanky;
    /**
     * The OdCastky
     * @var int
     */
    public $OdCastky;
    /**
     * The Predcisli
     * @var int
     */
    public $Predcisli;
    /**
     * The SpecSymbol
     * @var int
     */
    public $SpecSymbol;
    /**
     * The Ucet
     * @var int
     */
    public $Ucet;
    /**
     * The VeProspech
     * @var string
     */
    public $VeProspech;
    /**
     * The Vinkulace
     * @var string
     */
    public $Vinkulace;
    /**
     * Constructor method for Vinkulace
     * @uses Vinkulace::setKodBanky()
     * @uses Vinkulace::setOdCastky()
     * @uses Vinkulace::setPredcisli()
     * @uses Vinkulace::setSpecSymbol()
     * @uses Vinkulace::setUcet()
     * @uses Vinkulace::setVeProspech()
     * @uses Vinkulace::setVinkulace()
     * @param int $kodBanky
     * @param int $odCastky
     * @param int $predcisli
     * @param int $specSymbol
     * @param int $ucet
     * @param string $veProspech
     * @param string $vinkulace
     */
    public function __construct($kodBanky = null, $odCastky = null, $predcisli = null, $specSymbol = null, $ucet = null, $veProspech = null, $vinkulace = null)
    {
        $this
            ->setKodBanky($kodBanky)
            ->setOdCastky($odCastky)
            ->setPredcisli($predcisli)
            ->setSpecSymbol($specSymbol)
            ->setUcet($ucet)
            ->setVeProspech($veProspech)
            ->setVinkulace($vinkulace);
    }
    /**
     * Get KodBanky value
     * @return int|null
     */
    public function getKodBanky()
    {
        return $this->KodBanky;
    }
    /**
     * Set KodBanky value
     * @param int $kodBanky
     * @return \StructType\Vinkulace
     */
    public function setKodBanky($kodBanky = null)
    {
        // validation for constraint: int
        if (!is_null($kodBanky) && !is_numeric($kodBanky)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kodBanky)), __LINE__);
        }
        $this->KodBanky = $kodBanky;
        return $this;
    }
    /**
     * Get OdCastky value
     * @return int|null
     */
    public function getOdCastky()
    {
        return $this->OdCastky;
    }
    /**
     * Set OdCastky value
     * @param int $odCastky
     * @return \StructType\Vinkulace
     */
    public function setOdCastky($odCastky = null)
    {
        // validation for constraint: int
        if (!is_null($odCastky) && !is_numeric($odCastky)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($odCastky)), __LINE__);
        }
        $this->OdCastky = $odCastky;
        return $this;
    }
    /**
     * Get Predcisli value
     * @return int|null
     */
    public function getPredcisli()
    {
        return $this->Predcisli;
    }
    /**
     * Set Predcisli value
     * @param int $predcisli
     * @return \StructType\Vinkulace
     */
    public function setPredcisli($predcisli = null)
    {
        // validation for constraint: int
        if (!is_null($predcisli) && !is_numeric($predcisli)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($predcisli)), __LINE__);
        }
        $this->Predcisli = $predcisli;
        return $this;
    }
    /**
     * Get SpecSymbol value
     * @return int|null
     */
    public function getSpecSymbol()
    {
        return $this->SpecSymbol;
    }
    /**
     * Set SpecSymbol value
     * @param int $specSymbol
     * @return \StructType\Vinkulace
     */
    public function setSpecSymbol($specSymbol = null)
    {
        // validation for constraint: int
        if (!is_null($specSymbol) && !is_numeric($specSymbol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($specSymbol)), __LINE__);
        }
        $this->SpecSymbol = $specSymbol;
        return $this;
    }
    /**
     * Get Ucet value
     * @return int|null
     */
    public function getUcet()
    {
        return $this->Ucet;
    }
    /**
     * Set Ucet value
     * @param int $ucet
     * @return \StructType\Vinkulace
     */
    public function setUcet($ucet = null)
    {
        // validation for constraint: int
        if (!is_null($ucet) && !is_numeric($ucet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ucet)), __LINE__);
        }
        $this->Ucet = $ucet;
        return $this;
    }
    /**
     * Get VeProspech value
     * @return string|null
     */
    public function getVeProspech()
    {
        return $this->VeProspech;
    }
    /**
     * Set VeProspech value
     * @param string $veProspech
     * @return \StructType\Vinkulace
     */
    public function setVeProspech($veProspech = null)
    {
        // validation for constraint: string
        if (!is_null($veProspech) && !is_string($veProspech)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($veProspech)), __LINE__);
        }
        $this->VeProspech = $veProspech;
        return $this;
    }
    /**
     * Get Vinkulace value
     * @return string|null
     */
    public function getVinkulace()
    {
        return $this->Vinkulace;
    }
    /**
     * Set Vinkulace value
     * @param string $vinkulace
     * @return \StructType\Vinkulace
     */
    public function setVinkulace($vinkulace = null)
    {
        // validation for constraint: string
        if (!is_null($vinkulace) && !is_string($vinkulace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vinkulace)), __LINE__);
        }
        $this->Vinkulace = $vinkulace;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Vinkulace
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
