<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StornoIn StructType
 * @subpackage Structs
 */
class StornoIn extends AbstractStructBase
{
    /**
     * The CisloSmlouvy
     * @var string
     */
    public $CisloSmlouvy;
    /**
     * The DatumStorna
     * @var int
     */
    public $DatumStorna;
    /**
     * The PoradiVozidla
     * @var int
     */
    public $PoradiVozidla;
    /**
     * Constructor method for StornoIn
     * @uses StornoIn::setCisloSmlouvy()
     * @uses StornoIn::setDatumStorna()
     * @uses StornoIn::setPoradiVozidla()
     * @param string $cisloSmlouvy
     * @param int $datumStorna
     * @param int $poradiVozidla
     */
    public function __construct($cisloSmlouvy = null, $datumStorna = null, $poradiVozidla = null)
    {
        $this
            ->setCisloSmlouvy($cisloSmlouvy)
            ->setDatumStorna($datumStorna)
            ->setPoradiVozidla($poradiVozidla);
    }
    /**
     * Get CisloSmlouvy value
     * @return string|null
     */
    public function getCisloSmlouvy()
    {
        return $this->CisloSmlouvy;
    }
    /**
     * Set CisloSmlouvy value
     * @param string $cisloSmlouvy
     * @return \StructType\StornoIn
     */
    public function setCisloSmlouvy($cisloSmlouvy = null)
    {
        // validation for constraint: string
        if (!is_null($cisloSmlouvy) && !is_string($cisloSmlouvy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cisloSmlouvy)), __LINE__);
        }
        $this->CisloSmlouvy = $cisloSmlouvy;
        return $this;
    }
    /**
     * Get DatumStorna value
     * @return int|null
     */
    public function getDatumStorna()
    {
        return $this->DatumStorna;
    }
    /**
     * Set DatumStorna value
     * @param int $datumStorna
     * @return \StructType\StornoIn
     */
    public function setDatumStorna($datumStorna = null)
    {
        // validation for constraint: int
        if (!is_null($datumStorna) && !is_numeric($datumStorna)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($datumStorna)), __LINE__);
        }
        $this->DatumStorna = $datumStorna;
        return $this;
    }
    /**
     * Get PoradiVozidla value
     * @return int|null
     */
    public function getPoradiVozidla()
    {
        return $this->PoradiVozidla;
    }
    /**
     * Set PoradiVozidla value
     * @param int $poradiVozidla
     * @return \StructType\StornoIn
     */
    public function setPoradiVozidla($poradiVozidla = null)
    {
        // validation for constraint: int
        if (!is_null($poradiVozidla) && !is_numeric($poradiVozidla)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($poradiVozidla)), __LINE__);
        }
        $this->PoradiVozidla = $poradiVozidla;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StornoIn
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
