<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Smlouva StructType
 * @subpackage Structs
 */
class Smlouva extends AbstractStructBase
{
    /**
     * The CasSjednani
     * @var int
     */
    public $CasSjednani;
    /**
     * The CisloRamcoveSmlouvy
     * @var string
     */
    public $CisloRamcoveSmlouvy;
    /**
     * The CisloSmlouvy
     * @var string
     */
    public $CisloSmlouvy;
    /**
     * The DatumKoncePojisteni
     * @var string
     */
    public $DatumKoncePojisteni;
    /**
     * The DatumPocatku
     * @var string
     */
    public $DatumPocatku;
    /**
     * The DatumUzavreni
     * @var string
     */
    public $DatumUzavreni;
    /**
     * The DokumentURL
     * @var string
     */
    public $DokumentURL;
    /**
     * The EmailKalk
     * @var string
     */
    public $EmailKalk;
    /**
     * The EmailKlient
     * @var string
     */
    public $EmailKlient;
    /**
     * The GenKalk
     * @var string
     */
    public $GenKalk;
    /**
     * The GenVse
     * @var string
     */
    public $GenVse;
    /**
     * The HAV
     * @var \StructType\HAV
     */
    public $HAV;
    /**
     * The HodinaPocatku
     * @var string
     */
    public $HodinaPocatku;
    /**
     * The IdentZaznamu
     * @var int
     */
    public $IdentZaznamu;
    /**
     * The KodAkce
     * @var string
     */
    public $KodAkce;
    /**
     * The KodRezimu
     * @var int
     */
    public $KodRezimu;
    /**
     * The KoefProvize
     * @var int
     */
    public $KoefProvize;
    /**
     * The KorespondencniAdresa
     * @var \StructType\Adresa
     */
    public $KorespondencniAdresa;
    /**
     * The Makler
     * @var string
     */
    public $Makler;
    /**
     * The MaklerKod
     * @var int
     */
    public $MaklerKod;
    /**
     * The NahrazujeSmlouvu
     * @var string
     */
    public $NahrazujeSmlouvu;
    /**
     * The ObchodniSleva
     * @var string
     */
    public $ObchodniSleva;
    /**
     * The OdeslatPlatInstr
     * @var string
     */
    public $OdeslatPlatInstr;
    /**
     * The POV
     * @var \StructType\POV
     */
    public $POV;
    /**
     * The PlatnostZaplacenim
     * @var string
     */
    public $PlatnostZaplacenim;
    /**
     * The PocetSplatek
     * @var int
     */
    public $PocetSplatek;
    /**
     * The Pojisteni
     * Meta informations extracted from the WSDL
     * - arrayType: tns:Pojisteni[]
     * - ref: SOAP-ENC:arrayType
     * @var \StructType\Pojisteni[]
     */
    public $Pojisteni;
    /**
     * The Pojisteny
     * @var \StructType\Subjekt
     */
    public $Pojisteny;
    /**
     * The Pojistnik
     * @var \StructType\Subjekt
     */
    public $Pojistnik;
    /**
     * The PridelitCisloSmlouvy
     * @var string
     */
    public $PridelitCisloSmlouvy;
    /**
     * The ProduktKod
     * @var string
     */
    public $ProduktKod;
    /**
     * The ProvPoj
     * @var string
     */
    public $ProvPoj;
    /**
     * The Provozovatel
     * @var \StructType\Subjekt
     */
    public $Provozovatel;
    /**
     * The SipoSpojeni
     * @var string
     */
    public $SipoSpojeni;
    /**
     * The SjednatelMaklereKod
     * @var string
     */
    public $SjednatelMaklereKod;
    /**
     * The SluzbaKod
     * @var string
     */
    public $SluzbaKod;
    /**
     * The TiparKod
     * @var int
     */
    public $TiparKod;
    /**
     * The UpraveneRocniPojistne
     * @var int
     */
    public $UpraveneRocniPojistne;
    /**
     * The VlasPoj
     * @var string
     */
    public $VlasPoj;
    /**
     * The VlasPro
     * @var string
     */
    public $VlasPro;
    /**
     * The Vlastnik
     * @var \StructType\Subjekt
     */
    public $Vlastnik;
    /**
     * The VozidloSmlouvy
     * @var \StructType\VozidloSmlouvy
     */
    public $VozidloSmlouvy;
    /**
     * The ZarukaCeny3Roky
     * @var string
     */
    public $ZarukaCeny3Roky;
    /**
     * The ZelenaKarta
     * @var \StructType\ZelenaKarta
     */
    public $ZelenaKarta;
    /**
     * The ZpusobPlatby
     * @var string
     */
    public $ZpusobPlatby;
    /**
     * The ZpusobPlatby1Spl
     * @var string
     */
    public $ZpusobPlatby1Spl;
    /**
     * Constructor method for Smlouva
     * @uses Smlouva::setCasSjednani()
     * @uses Smlouva::setCisloRamcoveSmlouvy()
     * @uses Smlouva::setCisloSmlouvy()
     * @uses Smlouva::setDatumKoncePojisteni()
     * @uses Smlouva::setDatumPocatku()
     * @uses Smlouva::setDatumUzavreni()
     * @uses Smlouva::setDokumentURL()
     * @uses Smlouva::setEmailKalk()
     * @uses Smlouva::setEmailKlient()
     * @uses Smlouva::setGenKalk()
     * @uses Smlouva::setGenVse()
     * @uses Smlouva::setHAV()
     * @uses Smlouva::setHodinaPocatku()
     * @uses Smlouva::setIdentZaznamu()
     * @uses Smlouva::setKodAkce()
     * @uses Smlouva::setKodRezimu()
     * @uses Smlouva::setKoefProvize()
     * @uses Smlouva::setKorespondencniAdresa()
     * @uses Smlouva::setMakler()
     * @uses Smlouva::setMaklerKod()
     * @uses Smlouva::setNahrazujeSmlouvu()
     * @uses Smlouva::setObchodniSleva()
     * @uses Smlouva::setOdeslatPlatInstr()
     * @uses Smlouva::setPOV()
     * @uses Smlouva::setPlatnostZaplacenim()
     * @uses Smlouva::setPocetSplatek()
     * @uses Smlouva::setPojisteni()
     * @uses Smlouva::setPojisteny()
     * @uses Smlouva::setPojistnik()
     * @uses Smlouva::setPridelitCisloSmlouvy()
     * @uses Smlouva::setProduktKod()
     * @uses Smlouva::setProvPoj()
     * @uses Smlouva::setProvozovatel()
     * @uses Smlouva::setSipoSpojeni()
     * @uses Smlouva::setSjednatelMaklereKod()
     * @uses Smlouva::setSluzbaKod()
     * @uses Smlouva::setTiparKod()
     * @uses Smlouva::setUpraveneRocniPojistne()
     * @uses Smlouva::setVlasPoj()
     * @uses Smlouva::setVlasPro()
     * @uses Smlouva::setVlastnik()
     * @uses Smlouva::setVozidloSmlouvy()
     * @uses Smlouva::setZarukaCeny3Roky()
     * @uses Smlouva::setZelenaKarta()
     * @uses Smlouva::setZpusobPlatby()
     * @uses Smlouva::setZpusobPlatby1Spl()
     * @param int $casSjednani
     * @param string $cisloRamcoveSmlouvy
     * @param string $cisloSmlouvy
     * @param string $datumKoncePojisteni
     * @param string $datumPocatku
     * @param string $datumUzavreni
     * @param string $dokumentURL
     * @param string $emailKalk
     * @param string $emailKlient
     * @param string $genKalk
     * @param string $genVse
     * @param \StructType\HAV $hAV
     * @param string $hodinaPocatku
     * @param int $identZaznamu
     * @param string $kodAkce
     * @param int $kodRezimu
     * @param int $koefProvize
     * @param \StructType\Adresa $korespondencniAdresa
     * @param string $makler
     * @param int $maklerKod
     * @param string $nahrazujeSmlouvu
     * @param string $obchodniSleva
     * @param string $odeslatPlatInstr
     * @param \StructType\POV $pOV
     * @param string $platnostZaplacenim
     * @param int $pocetSplatek
     * @param \StructType\Pojisteni[] $pojisteni
     * @param \StructType\Subjekt $pojisteny
     * @param \StructType\Subjekt $pojistnik
     * @param string $pridelitCisloSmlouvy
     * @param string $produktKod
     * @param string $provPoj
     * @param \StructType\Subjekt $provozovatel
     * @param string $sipoSpojeni
     * @param string $sjednatelMaklereKod
     * @param string $sluzbaKod
     * @param int $tiparKod
     * @param int $upraveneRocniPojistne
     * @param string $vlasPoj
     * @param string $vlasPro
     * @param \StructType\Subjekt $vlastnik
     * @param \StructType\VozidloSmlouvy $vozidloSmlouvy
     * @param string $zarukaCeny3Roky
     * @param \StructType\ZelenaKarta $zelenaKarta
     * @param string $zpusobPlatby
     * @param string $zpusobPlatby1Spl
     */
    public function __construct($casSjednani = null, $cisloRamcoveSmlouvy = null, $cisloSmlouvy = null, $datumKoncePojisteni = null, $datumPocatku = null, $datumUzavreni = null, $dokumentURL = null, $emailKalk = null, $emailKlient = null, $genKalk = null, $genVse = null, \StructType\HAV $hAV = null, $hodinaPocatku = null, $identZaznamu = null, $kodAkce = null, $kodRezimu = null, $koefProvize = null, \StructType\Adresa $korespondencniAdresa = null, $makler = null, $maklerKod = null, $nahrazujeSmlouvu = null, $obchodniSleva = null, $odeslatPlatInstr = null, \StructType\POV $pOV = null, $platnostZaplacenim = null, $pocetSplatek = null, array $pojisteni = array(), \StructType\Subjekt $pojisteny = null, \StructType\Subjekt $pojistnik = null, $pridelitCisloSmlouvy = null, $produktKod = null, $provPoj = null, \StructType\Subjekt $provozovatel = null, $sipoSpojeni = null, $sjednatelMaklereKod = null, $sluzbaKod = null, $tiparKod = null, $upraveneRocniPojistne = null, $vlasPoj = null, $vlasPro = null, \StructType\Subjekt $vlastnik = null, \StructType\VozidloSmlouvy $vozidloSmlouvy = null, $zarukaCeny3Roky = null, \StructType\ZelenaKarta $zelenaKarta = null, $zpusobPlatby = null, $zpusobPlatby1Spl = null)
    {
        $this
            ->setCasSjednani($casSjednani)
            ->setCisloRamcoveSmlouvy($cisloRamcoveSmlouvy)
            ->setCisloSmlouvy($cisloSmlouvy)
            ->setDatumKoncePojisteni($datumKoncePojisteni)
            ->setDatumPocatku($datumPocatku)
            ->setDatumUzavreni($datumUzavreni)
            ->setDokumentURL($dokumentURL)
            ->setEmailKalk($emailKalk)
            ->setEmailKlient($emailKlient)
            ->setGenKalk($genKalk)
            ->setGenVse($genVse)
            ->setHAV($hAV)
            ->setHodinaPocatku($hodinaPocatku)
            ->setIdentZaznamu($identZaznamu)
            ->setKodAkce($kodAkce)
            ->setKodRezimu($kodRezimu)
            ->setKoefProvize($koefProvize)
            ->setKorespondencniAdresa($korespondencniAdresa)
            ->setMakler($makler)
            ->setMaklerKod($maklerKod)
            ->setNahrazujeSmlouvu($nahrazujeSmlouvu)
            ->setObchodniSleva($obchodniSleva)
            ->setOdeslatPlatInstr($odeslatPlatInstr)
            ->setPOV($pOV)
            ->setPlatnostZaplacenim($platnostZaplacenim)
            ->setPocetSplatek($pocetSplatek)
            ->setPojisteni($pojisteni)
            ->setPojisteny($pojisteny)
            ->setPojistnik($pojistnik)
            ->setPridelitCisloSmlouvy($pridelitCisloSmlouvy)
            ->setProduktKod($produktKod)
            ->setProvPoj($provPoj)
            ->setProvozovatel($provozovatel)
            ->setSipoSpojeni($sipoSpojeni)
            ->setSjednatelMaklereKod($sjednatelMaklereKod)
            ->setSluzbaKod($sluzbaKod)
            ->setTiparKod($tiparKod)
            ->setUpraveneRocniPojistne($upraveneRocniPojistne)
            ->setVlasPoj($vlasPoj)
            ->setVlasPro($vlasPro)
            ->setVlastnik($vlastnik)
            ->setVozidloSmlouvy($vozidloSmlouvy)
            ->setZarukaCeny3Roky($zarukaCeny3Roky)
            ->setZelenaKarta($zelenaKarta)
            ->setZpusobPlatby($zpusobPlatby)
            ->setZpusobPlatby1Spl($zpusobPlatby1Spl);
    }
    /**
     * Get CasSjednani value
     * @return int|null
     */
    public function getCasSjednani()
    {
        return $this->CasSjednani;
    }
    /**
     * Set CasSjednani value
     * @param int $casSjednani
     * @return \StructType\Smlouva
     */
    public function setCasSjednani($casSjednani = null)
    {
        // validation for constraint: int
        if (!is_null($casSjednani) && !is_numeric($casSjednani)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($casSjednani)), __LINE__);
        }
        $this->CasSjednani = $casSjednani;
        return $this;
    }
    /**
     * Get CisloRamcoveSmlouvy value
     * @return string|null
     */
    public function getCisloRamcoveSmlouvy()
    {
        return $this->CisloRamcoveSmlouvy;
    }
    /**
     * Set CisloRamcoveSmlouvy value
     * @param string $cisloRamcoveSmlouvy
     * @return \StructType\Smlouva
     */
    public function setCisloRamcoveSmlouvy($cisloRamcoveSmlouvy = null)
    {
        // validation for constraint: string
        if (!is_null($cisloRamcoveSmlouvy) && !is_string($cisloRamcoveSmlouvy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cisloRamcoveSmlouvy)), __LINE__);
        }
        $this->CisloRamcoveSmlouvy = $cisloRamcoveSmlouvy;
        return $this;
    }
    /**
     * Get CisloSmlouvy value
     * @return string|null
     */
    public function getCisloSmlouvy()
    {
        return $this->CisloSmlouvy;
    }
    /**
     * Set CisloSmlouvy value
     * @param string $cisloSmlouvy
     * @return \StructType\Smlouva
     */
    public function setCisloSmlouvy($cisloSmlouvy = null)
    {
        // validation for constraint: string
        if (!is_null($cisloSmlouvy) && !is_string($cisloSmlouvy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cisloSmlouvy)), __LINE__);
        }
        $this->CisloSmlouvy = $cisloSmlouvy;
        return $this;
    }
    /**
     * Get DatumKoncePojisteni value
     * @return string|null
     */
    public function getDatumKoncePojisteni()
    {
        return $this->DatumKoncePojisteni;
    }
    /**
     * Set DatumKoncePojisteni value
     * @param string $datumKoncePojisteni
     * @return \StructType\Smlouva
     */
    public function setDatumKoncePojisteni($datumKoncePojisteni = null)
    {
        // validation for constraint: string
        if (!is_null($datumKoncePojisteni) && !is_string($datumKoncePojisteni)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datumKoncePojisteni)), __LINE__);
        }
        $this->DatumKoncePojisteni = $datumKoncePojisteni;
        return $this;
    }
    /**
     * Get DatumPocatku value
     * @return string|null
     */
    public function getDatumPocatku()
    {
        return $this->DatumPocatku;
    }
    /**
     * Set DatumPocatku value
     * @param string $datumPocatku
     * @return \StructType\Smlouva
     */
    public function setDatumPocatku($datumPocatku = null)
    {
        // validation for constraint: string
        if (!is_null($datumPocatku) && !is_string($datumPocatku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datumPocatku)), __LINE__);
        }
        $this->DatumPocatku = $datumPocatku;
        return $this;
    }
    /**
     * Get DatumUzavreni value
     * @return string|null
     */
    public function getDatumUzavreni()
    {
        return $this->DatumUzavreni;
    }
    /**
     * Set DatumUzavreni value
     * @param string $datumUzavreni
     * @return \StructType\Smlouva
     */
    public function setDatumUzavreni($datumUzavreni = null)
    {
        // validation for constraint: string
        if (!is_null($datumUzavreni) && !is_string($datumUzavreni)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datumUzavreni)), __LINE__);
        }
        $this->DatumUzavreni = $datumUzavreni;
        return $this;
    }
    /**
     * Get DokumentURL value
     * @return string|null
     */
    public function getDokumentURL()
    {
        return $this->DokumentURL;
    }
    /**
     * Set DokumentURL value
     * @param string $dokumentURL
     * @return \StructType\Smlouva
     */
    public function setDokumentURL($dokumentURL = null)
    {
        // validation for constraint: string
        if (!is_null($dokumentURL) && !is_string($dokumentURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dokumentURL)), __LINE__);
        }
        $this->DokumentURL = $dokumentURL;
        return $this;
    }
    /**
     * Get EmailKalk value
     * @return string|null
     */
    public function getEmailKalk()
    {
        return $this->EmailKalk;
    }
    /**
     * Set EmailKalk value
     * @param string $emailKalk
     * @return \StructType\Smlouva
     */
    public function setEmailKalk($emailKalk = null)
    {
        // validation for constraint: string
        if (!is_null($emailKalk) && !is_string($emailKalk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailKalk)), __LINE__);
        }
        $this->EmailKalk = $emailKalk;
        return $this;
    }
    /**
     * Get EmailKlient value
     * @return string|null
     */
    public function getEmailKlient()
    {
        return $this->EmailKlient;
    }
    /**
     * Set EmailKlient value
     * @param string $emailKlient
     * @return \StructType\Smlouva
     */
    public function setEmailKlient($emailKlient = null)
    {
        // validation for constraint: string
        if (!is_null($emailKlient) && !is_string($emailKlient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailKlient)), __LINE__);
        }
        $this->EmailKlient = $emailKlient;
        return $this;
    }
    /**
     * Get GenKalk value
     * @return string|null
     */
    public function getGenKalk()
    {
        return $this->GenKalk;
    }
    /**
     * Set GenKalk value
     * @param string $genKalk
     * @return \StructType\Smlouva
     */
    public function setGenKalk($genKalk = null)
    {
        // validation for constraint: string
        if (!is_null($genKalk) && !is_string($genKalk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($genKalk)), __LINE__);
        }
        $this->GenKalk = $genKalk;
        return $this;
    }
    /**
     * Get GenVse value
     * @return string|null
     */
    public function getGenVse()
    {
        return $this->GenVse;
    }
    /**
     * Set GenVse value
     * @param string $genVse
     * @return \StructType\Smlouva
     */
    public function setGenVse($genVse = null)
    {
        // validation for constraint: string
        if (!is_null($genVse) && !is_string($genVse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($genVse)), __LINE__);
        }
        $this->GenVse = $genVse;
        return $this;
    }
    /**
     * Get HAV value
     * @return \StructType\HAV|null
     */
    public function getHAV()
    {
        return $this->HAV;
    }
    /**
     * Set HAV value
     * @param \StructType\HAV $hAV
     * @return \StructType\Smlouva
     */
    public function setHAV(\StructType\HAV $hAV = null)
    {
        $this->HAV = $hAV;
        return $this;
    }
    /**
     * Get HodinaPocatku value
     * @return string|null
     */
    public function getHodinaPocatku()
    {
        return $this->HodinaPocatku;
    }
    /**
     * Set HodinaPocatku value
     * @param string $hodinaPocatku
     * @return \StructType\Smlouva
     */
    public function setHodinaPocatku($hodinaPocatku = null)
    {
        // validation for constraint: string
        if (!is_null($hodinaPocatku) && !is_string($hodinaPocatku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hodinaPocatku)), __LINE__);
        }
        $this->HodinaPocatku = $hodinaPocatku;
        return $this;
    }
    /**
     * Get IdentZaznamu value
     * @return int|null
     */
    public function getIdentZaznamu()
    {
        return $this->IdentZaznamu;
    }
    /**
     * Set IdentZaznamu value
     * @param int $identZaznamu
     * @return \StructType\Smlouva
     */
    public function setIdentZaznamu($identZaznamu = null)
    {
        // validation for constraint: int
        if (!is_null($identZaznamu) && !is_numeric($identZaznamu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($identZaznamu)), __LINE__);
        }
        $this->IdentZaznamu = $identZaznamu;
        return $this;
    }
    /**
     * Get KodAkce value
     * @return string|null
     */
    public function getKodAkce()
    {
        return $this->KodAkce;
    }
    /**
     * Set KodAkce value
     * @param string $kodAkce
     * @return \StructType\Smlouva
     */
    public function setKodAkce($kodAkce = null)
    {
        // validation for constraint: string
        if (!is_null($kodAkce) && !is_string($kodAkce)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kodAkce)), __LINE__);
        }
        $this->KodAkce = $kodAkce;
        return $this;
    }
    /**
     * Get KodRezimu value
     * @return int|null
     */
    public function getKodRezimu()
    {
        return $this->KodRezimu;
    }
    /**
     * Set KodRezimu value
     * @param int $kodRezimu
     * @return \StructType\Smlouva
     */
    public function setKodRezimu($kodRezimu = null)
    {
        // validation for constraint: int
        if (!is_null($kodRezimu) && !is_numeric($kodRezimu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kodRezimu)), __LINE__);
        }
        $this->KodRezimu = $kodRezimu;
        return $this;
    }
    /**
     * Get KoefProvize value
     * @return int|null
     */
    public function getKoefProvize()
    {
        return $this->KoefProvize;
    }
    /**
     * Set KoefProvize value
     * @param int $koefProvize
     * @return \StructType\Smlouva
     */
    public function setKoefProvize($koefProvize = null)
    {
        // validation for constraint: int
        if (!is_null($koefProvize) && !is_numeric($koefProvize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($koefProvize)), __LINE__);
        }
        $this->KoefProvize = $koefProvize;
        return $this;
    }
    /**
     * Get KorespondencniAdresa value
     * @return \StructType\Adresa|null
     */
    public function getKorespondencniAdresa()
    {
        return $this->KorespondencniAdresa;
    }
    /**
     * Set KorespondencniAdresa value
     * @param \StructType\Adresa $korespondencniAdresa
     * @return \StructType\Smlouva
     */
    public function setKorespondencniAdresa(\StructType\Adresa $korespondencniAdresa = null)
    {
        $this->KorespondencniAdresa = $korespondencniAdresa;
        return $this;
    }
    /**
     * Get Makler value
     * @return string|null
     */
    public function getMakler()
    {
        return $this->Makler;
    }
    /**
     * Set Makler value
     * @param string $makler
     * @return \StructType\Smlouva
     */
    public function setMakler($makler = null)
    {
        // validation for constraint: string
        if (!is_null($makler) && !is_string($makler)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($makler)), __LINE__);
        }
        $this->Makler = $makler;
        return $this;
    }
    /**
     * Get MaklerKod value
     * @return int|null
     */
    public function getMaklerKod()
    {
        return $this->MaklerKod;
    }
    /**
     * Set MaklerKod value
     * @param int $maklerKod
     * @return \StructType\Smlouva
     */
    public function setMaklerKod($maklerKod = null)
    {
        // validation for constraint: int
        if (!is_null($maklerKod) && !is_numeric($maklerKod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maklerKod)), __LINE__);
        }
        $this->MaklerKod = $maklerKod;
        return $this;
    }
    /**
     * Get NahrazujeSmlouvu value
     * @return string|null
     */
    public function getNahrazujeSmlouvu()
    {
        return $this->NahrazujeSmlouvu;
    }
    /**
     * Set NahrazujeSmlouvu value
     * @param string $nahrazujeSmlouvu
     * @return \StructType\Smlouva
     */
    public function setNahrazujeSmlouvu($nahrazujeSmlouvu = null)
    {
        // validation for constraint: string
        if (!is_null($nahrazujeSmlouvu) && !is_string($nahrazujeSmlouvu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nahrazujeSmlouvu)), __LINE__);
        }
        $this->NahrazujeSmlouvu = $nahrazujeSmlouvu;
        return $this;
    }
    /**
     * Get ObchodniSleva value
     * @return string|null
     */
    public function getObchodniSleva()
    {
        return $this->ObchodniSleva;
    }
    /**
     * Set ObchodniSleva value
     * @param string $obchodniSleva
     * @return \StructType\Smlouva
     */
    public function setObchodniSleva($obchodniSleva = null)
    {
        // validation for constraint: string
        if (!is_null($obchodniSleva) && !is_string($obchodniSleva)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($obchodniSleva)), __LINE__);
        }
        $this->ObchodniSleva = $obchodniSleva;
        return $this;
    }
    /**
     * Get OdeslatPlatInstr value
     * @return string|null
     */
    public function getOdeslatPlatInstr()
    {
        return $this->OdeslatPlatInstr;
    }
    /**
     * Set OdeslatPlatInstr value
     * @param string $odeslatPlatInstr
     * @return \StructType\Smlouva
     */
    public function setOdeslatPlatInstr($odeslatPlatInstr = null)
    {
        // validation for constraint: string
        if (!is_null($odeslatPlatInstr) && !is_string($odeslatPlatInstr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($odeslatPlatInstr)), __LINE__);
        }
        $this->OdeslatPlatInstr = $odeslatPlatInstr;
        return $this;
    }
    /**
     * Get POV value
     * @return \StructType\POV|null
     */
    public function getPOV()
    {
        return $this->POV;
    }
    /**
     * Set POV value
     * @param \StructType\POV $pOV
     * @return \StructType\Smlouva
     */
    public function setPOV(\StructType\POV $pOV = null)
    {
        $this->POV = $pOV;
        return $this;
    }
    /**
     * Get PlatnostZaplacenim value
     * @return string|null
     */
    public function getPlatnostZaplacenim()
    {
        return $this->PlatnostZaplacenim;
    }
    /**
     * Set PlatnostZaplacenim value
     * @param string $platnostZaplacenim
     * @return \StructType\Smlouva
     */
    public function setPlatnostZaplacenim($platnostZaplacenim = null)
    {
        // validation for constraint: string
        if (!is_null($platnostZaplacenim) && !is_string($platnostZaplacenim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($platnostZaplacenim)), __LINE__);
        }
        $this->PlatnostZaplacenim = $platnostZaplacenim;
        return $this;
    }
    /**
     * Get PocetSplatek value
     * @return int|null
     */
    public function getPocetSplatek()
    {
        return $this->PocetSplatek;
    }
    /**
     * Set PocetSplatek value
     * @param int $pocetSplatek
     * @return \StructType\Smlouva
     */
    public function setPocetSplatek($pocetSplatek = null)
    {
        // validation for constraint: int
        if (!is_null($pocetSplatek) && !is_numeric($pocetSplatek)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pocetSplatek)), __LINE__);
        }
        $this->PocetSplatek = $pocetSplatek;
        return $this;
    }
    /**
     * Get Pojisteni value
     * @return \StructType\Pojisteni[]|null
     */
    public function getPojisteni()
    {
        return $this->Pojisteni;
    }
    /**
     * Set Pojisteni value
     * @throws \InvalidArgumentException
     * @param \StructType\Pojisteni[] $pojisteni
     * @return \StructType\Smlouva
     */
    public function setPojisteni(array $pojisteni = array())
    {
        foreach ($pojisteni as $smlouvaPojisteniItem) {
            // validation for constraint: itemType
            if (!$smlouvaPojisteniItem instanceof \StructType\Pojisteni) {
                throw new \InvalidArgumentException(sprintf('The Pojisteni property can only contain items of \StructType\Pojisteni, "%s" given', is_object($smlouvaPojisteniItem) ? get_class($smlouvaPojisteniItem) : gettype($smlouvaPojisteniItem)), __LINE__);
            }
        }
        $this->Pojisteni = $pojisteni;
        return $this;
    }
    /**
     * Add item to Pojisteni value
     * @throws \InvalidArgumentException
     * @param \StructType\Pojisteni $item
     * @return \StructType\Smlouva
     */
    public function addToPojisteni(\StructType\Pojisteni $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Pojisteni) {
            throw new \InvalidArgumentException(sprintf('The Pojisteni property can only contain items of \StructType\Pojisteni, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Pojisteni[] = $item;
        return $this;
    }
    /**
     * Get Pojisteny value
     * @return \StructType\Subjekt|null
     */
    public function getPojisteny()
    {
        return $this->Pojisteny;
    }
    /**
     * Set Pojisteny value
     * @param \StructType\Subjekt $pojisteny
     * @return \StructType\Smlouva
     */
    public function setPojisteny(\StructType\Subjekt $pojisteny = null)
    {
        $this->Pojisteny = $pojisteny;
        return $this;
    }
    /**
     * Get Pojistnik value
     * @return \StructType\Subjekt|null
     */
    public function getPojistnik()
    {
        return $this->Pojistnik;
    }
    /**
     * Set Pojistnik value
     * @param \StructType\Subjekt $pojistnik
     * @return \StructType\Smlouva
     */
    public function setPojistnik(\StructType\Subjekt $pojistnik = null)
    {
        $this->Pojistnik = $pojistnik;
        return $this;
    }
    /**
     * Get PridelitCisloSmlouvy value
     * @return string|null
     */
    public function getPridelitCisloSmlouvy()
    {
        return $this->PridelitCisloSmlouvy;
    }
    /**
     * Set PridelitCisloSmlouvy value
     * @param string $pridelitCisloSmlouvy
     * @return \StructType\Smlouva
     */
    public function setPridelitCisloSmlouvy($pridelitCisloSmlouvy = null)
    {
        // validation for constraint: string
        if (!is_null($pridelitCisloSmlouvy) && !is_string($pridelitCisloSmlouvy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pridelitCisloSmlouvy)), __LINE__);
        }
        $this->PridelitCisloSmlouvy = $pridelitCisloSmlouvy;
        return $this;
    }
    /**
     * Get ProduktKod value
     * @return string|null
     */
    public function getProduktKod()
    {
        return $this->ProduktKod;
    }
    /**
     * Set ProduktKod value
     * @param string $produktKod
     * @return \StructType\Smlouva
     */
    public function setProduktKod($produktKod = null)
    {
        // validation for constraint: string
        if (!is_null($produktKod) && !is_string($produktKod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($produktKod)), __LINE__);
        }
        $this->ProduktKod = $produktKod;
        return $this;
    }
    /**
     * Get ProvPoj value
     * @return string|null
     */
    public function getProvPoj()
    {
        return $this->ProvPoj;
    }
    /**
     * Set ProvPoj value
     * @param string $provPoj
     * @return \StructType\Smlouva
     */
    public function setProvPoj($provPoj = null)
    {
        // validation for constraint: string
        if (!is_null($provPoj) && !is_string($provPoj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($provPoj)), __LINE__);
        }
        $this->ProvPoj = $provPoj;
        return $this;
    }
    /**
     * Get Provozovatel value
     * @return \StructType\Subjekt|null
     */
    public function getProvozovatel()
    {
        return $this->Provozovatel;
    }
    /**
     * Set Provozovatel value
     * @param \StructType\Subjekt $provozovatel
     * @return \StructType\Smlouva
     */
    public function setProvozovatel(\StructType\Subjekt $provozovatel = null)
    {
        $this->Provozovatel = $provozovatel;
        return $this;
    }
    /**
     * Get SipoSpojeni value
     * @return string|null
     */
    public function getSipoSpojeni()
    {
        return $this->SipoSpojeni;
    }
    /**
     * Set SipoSpojeni value
     * @param string $sipoSpojeni
     * @return \StructType\Smlouva
     */
    public function setSipoSpojeni($sipoSpojeni = null)
    {
        // validation for constraint: string
        if (!is_null($sipoSpojeni) && !is_string($sipoSpojeni)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sipoSpojeni)), __LINE__);
        }
        $this->SipoSpojeni = $sipoSpojeni;
        return $this;
    }
    /**
     * Get SjednatelMaklereKod value
     * @return string|null
     */
    public function getSjednatelMaklereKod()
    {
        return $this->SjednatelMaklereKod;
    }
    /**
     * Set SjednatelMaklereKod value
     * @param string $sjednatelMaklereKod
     * @return \StructType\Smlouva
     */
    public function setSjednatelMaklereKod($sjednatelMaklereKod = null)
    {
        // validation for constraint: string
        if (!is_null($sjednatelMaklereKod) && !is_string($sjednatelMaklereKod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sjednatelMaklereKod)), __LINE__);
        }
        $this->SjednatelMaklereKod = $sjednatelMaklereKod;
        return $this;
    }
    /**
     * Get SluzbaKod value
     * @return string|null
     */
    public function getSluzbaKod()
    {
        return $this->SluzbaKod;
    }
    /**
     * Set SluzbaKod value
     * @param string $sluzbaKod
     * @return \StructType\Smlouva
     */
    public function setSluzbaKod($sluzbaKod = null)
    {
        // validation for constraint: string
        if (!is_null($sluzbaKod) && !is_string($sluzbaKod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sluzbaKod)), __LINE__);
        }
        $this->SluzbaKod = $sluzbaKod;
        return $this;
    }
    /**
     * Get TiparKod value
     * @return int|null
     */
    public function getTiparKod()
    {
        return $this->TiparKod;
    }
    /**
     * Set TiparKod value
     * @param int $tiparKod
     * @return \StructType\Smlouva
     */
    public function setTiparKod($tiparKod = null)
    {
        // validation for constraint: int
        if (!is_null($tiparKod) && !is_numeric($tiparKod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tiparKod)), __LINE__);
        }
        $this->TiparKod = $tiparKod;
        return $this;
    }
    /**
     * Get UpraveneRocniPojistne value
     * @return int|null
     */
    public function getUpraveneRocniPojistne()
    {
        return $this->UpraveneRocniPojistne;
    }
    /**
     * Set UpraveneRocniPojistne value
     * @param int $upraveneRocniPojistne
     * @return \StructType\Smlouva
     */
    public function setUpraveneRocniPojistne($upraveneRocniPojistne = null)
    {
        // validation for constraint: int
        if (!is_null($upraveneRocniPojistne) && !is_numeric($upraveneRocniPojistne)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($upraveneRocniPojistne)), __LINE__);
        }
        $this->UpraveneRocniPojistne = $upraveneRocniPojistne;
        return $this;
    }
    /**
     * Get VlasPoj value
     * @return string|null
     */
    public function getVlasPoj()
    {
        return $this->VlasPoj;
    }
    /**
     * Set VlasPoj value
     * @param string $vlasPoj
     * @return \StructType\Smlouva
     */
    public function setVlasPoj($vlasPoj = null)
    {
        // validation for constraint: string
        if (!is_null($vlasPoj) && !is_string($vlasPoj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vlasPoj)), __LINE__);
        }
        $this->VlasPoj = $vlasPoj;
        return $this;
    }
    /**
     * Get VlasPro value
     * @return string|null
     */
    public function getVlasPro()
    {
        return $this->VlasPro;
    }
    /**
     * Set VlasPro value
     * @param string $vlasPro
     * @return \StructType\Smlouva
     */
    public function setVlasPro($vlasPro = null)
    {
        // validation for constraint: string
        if (!is_null($vlasPro) && !is_string($vlasPro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vlasPro)), __LINE__);
        }
        $this->VlasPro = $vlasPro;
        return $this;
    }
    /**
     * Get Vlastnik value
     * @return \StructType\Subjekt|null
     */
    public function getVlastnik()
    {
        return $this->Vlastnik;
    }
    /**
     * Set Vlastnik value
     * @param \StructType\Subjekt $vlastnik
     * @return \StructType\Smlouva
     */
    public function setVlastnik(\StructType\Subjekt $vlastnik = null)
    {
        $this->Vlastnik = $vlastnik;
        return $this;
    }
    /**
     * Get VozidloSmlouvy value
     * @return \StructType\VozidloSmlouvy|null
     */
    public function getVozidloSmlouvy()
    {
        return $this->VozidloSmlouvy;
    }
    /**
     * Set VozidloSmlouvy value
     * @param \StructType\VozidloSmlouvy $vozidloSmlouvy
     * @return \StructType\Smlouva
     */
    public function setVozidloSmlouvy(\StructType\VozidloSmlouvy $vozidloSmlouvy = null)
    {
        $this->VozidloSmlouvy = $vozidloSmlouvy;
        return $this;
    }
    /**
     * Get ZarukaCeny3Roky value
     * @return string|null
     */
    public function getZarukaCeny3Roky()
    {
        return $this->ZarukaCeny3Roky;
    }
    /**
     * Set ZarukaCeny3Roky value
     * @param string $zarukaCeny3Roky
     * @return \StructType\Smlouva
     */
    public function setZarukaCeny3Roky($zarukaCeny3Roky = null)
    {
        // validation for constraint: string
        if (!is_null($zarukaCeny3Roky) && !is_string($zarukaCeny3Roky)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zarukaCeny3Roky)), __LINE__);
        }
        $this->ZarukaCeny3Roky = $zarukaCeny3Roky;
        return $this;
    }
    /**
     * Get ZelenaKarta value
     * @return \StructType\ZelenaKarta|null
     */
    public function getZelenaKarta()
    {
        return $this->ZelenaKarta;
    }
    /**
     * Set ZelenaKarta value
     * @param \StructType\ZelenaKarta $zelenaKarta
     * @return \StructType\Smlouva
     */
    public function setZelenaKarta(\StructType\ZelenaKarta $zelenaKarta = null)
    {
        $this->ZelenaKarta = $zelenaKarta;
        return $this;
    }
    /**
     * Get ZpusobPlatby value
     * @return string|null
     */
    public function getZpusobPlatby()
    {
        return $this->ZpusobPlatby;
    }
    /**
     * Set ZpusobPlatby value
     * @param string $zpusobPlatby
     * @return \StructType\Smlouva
     */
    public function setZpusobPlatby($zpusobPlatby = null)
    {
        // validation for constraint: string
        if (!is_null($zpusobPlatby) && !is_string($zpusobPlatby)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zpusobPlatby)), __LINE__);
        }
        $this->ZpusobPlatby = $zpusobPlatby;
        return $this;
    }
    /**
     * Get ZpusobPlatby1Spl value
     * @return string|null
     */
    public function getZpusobPlatby1Spl()
    {
        return $this->ZpusobPlatby1Spl;
    }
    /**
     * Set ZpusobPlatby1Spl value
     * @param string $zpusobPlatby1Spl
     * @return \StructType\Smlouva
     */
    public function setZpusobPlatby1Spl($zpusobPlatby1Spl = null)
    {
        // validation for constraint: string
        if (!is_null($zpusobPlatby1Spl) && !is_string($zpusobPlatby1Spl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zpusobPlatby1Spl)), __LINE__);
        }
        $this->ZpusobPlatby1Spl = $zpusobPlatby1Spl;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Smlouva
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
