<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SlevyHAV StructType
 * @subpackage Structs
 */
class SlevyHAV extends AbstractStructBase
{
    /**
     * The AktivniZabezpeceni
     * @var string
     */
    public $AktivniZabezpeceni;
    /**
     * The Alarm
     * @var string
     */
    public $Alarm;
    /**
     * The BonusPotvrzen
     * @var string
     */
    public $BonusPotvrzen;
    /**
     * The Imobilizer
     * @var string
     */
    public $Imobilizer;
    /**
     * The PasivniVyhledavani
     * @var string
     */
    public $PasivniVyhledavani;
    /**
     * The PocetMesicu
     * @var int
     */
    public $PocetMesicu;
    /**
     * The UplatnitBonusPOV
     * @var string
     */
    public $UplatnitBonusPOV;
    /**
     * The ZabezpMech
     * @var string
     */
    public $ZabezpMech;
    /**
     * The ZnaceniSkel
     * @var string
     */
    public $ZnaceniSkel;
    /**
     * Constructor method for SlevyHAV
     * @uses SlevyHAV::setAktivniZabezpeceni()
     * @uses SlevyHAV::setAlarm()
     * @uses SlevyHAV::setBonusPotvrzen()
     * @uses SlevyHAV::setImobilizer()
     * @uses SlevyHAV::setPasivniVyhledavani()
     * @uses SlevyHAV::setPocetMesicu()
     * @uses SlevyHAV::setUplatnitBonusPOV()
     * @uses SlevyHAV::setZabezpMech()
     * @uses SlevyHAV::setZnaceniSkel()
     * @param string $aktivniZabezpeceni
     * @param string $alarm
     * @param string $bonusPotvrzen
     * @param string $imobilizer
     * @param string $pasivniVyhledavani
     * @param int $pocetMesicu
     * @param string $uplatnitBonusPOV
     * @param string $zabezpMech
     * @param string $znaceniSkel
     */
    public function __construct($aktivniZabezpeceni = null, $alarm = null, $bonusPotvrzen = null, $imobilizer = null, $pasivniVyhledavani = null, $pocetMesicu = null, $uplatnitBonusPOV = null, $zabezpMech = null, $znaceniSkel = null)
    {
        $this
            ->setAktivniZabezpeceni($aktivniZabezpeceni)
            ->setAlarm($alarm)
            ->setBonusPotvrzen($bonusPotvrzen)
            ->setImobilizer($imobilizer)
            ->setPasivniVyhledavani($pasivniVyhledavani)
            ->setPocetMesicu($pocetMesicu)
            ->setUplatnitBonusPOV($uplatnitBonusPOV)
            ->setZabezpMech($zabezpMech)
            ->setZnaceniSkel($znaceniSkel);
    }
    /**
     * Get AktivniZabezpeceni value
     * @return string|null
     */
    public function getAktivniZabezpeceni()
    {
        return $this->AktivniZabezpeceni;
    }
    /**
     * Set AktivniZabezpeceni value
     * @param string $aktivniZabezpeceni
     * @return \StructType\SlevyHAV
     */
    public function setAktivniZabezpeceni($aktivniZabezpeceni = null)
    {
        // validation for constraint: string
        if (!is_null($aktivniZabezpeceni) && !is_string($aktivniZabezpeceni)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aktivniZabezpeceni)), __LINE__);
        }
        $this->AktivniZabezpeceni = $aktivniZabezpeceni;
        return $this;
    }
    /**
     * Get Alarm value
     * @return string|null
     */
    public function getAlarm()
    {
        return $this->Alarm;
    }
    /**
     * Set Alarm value
     * @param string $alarm
     * @return \StructType\SlevyHAV
     */
    public function setAlarm($alarm = null)
    {
        // validation for constraint: string
        if (!is_null($alarm) && !is_string($alarm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alarm)), __LINE__);
        }
        $this->Alarm = $alarm;
        return $this;
    }
    /**
     * Get BonusPotvrzen value
     * @return string|null
     */
    public function getBonusPotvrzen()
    {
        return $this->BonusPotvrzen;
    }
    /**
     * Set BonusPotvrzen value
     * @param string $bonusPotvrzen
     * @return \StructType\SlevyHAV
     */
    public function setBonusPotvrzen($bonusPotvrzen = null)
    {
        // validation for constraint: string
        if (!is_null($bonusPotvrzen) && !is_string($bonusPotvrzen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bonusPotvrzen)), __LINE__);
        }
        $this->BonusPotvrzen = $bonusPotvrzen;
        return $this;
    }
    /**
     * Get Imobilizer value
     * @return string|null
     */
    public function getImobilizer()
    {
        return $this->Imobilizer;
    }
    /**
     * Set Imobilizer value
     * @param string $imobilizer
     * @return \StructType\SlevyHAV
     */
    public function setImobilizer($imobilizer = null)
    {
        // validation for constraint: string
        if (!is_null($imobilizer) && !is_string($imobilizer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imobilizer)), __LINE__);
        }
        $this->Imobilizer = $imobilizer;
        return $this;
    }
    /**
     * Get PasivniVyhledavani value
     * @return string|null
     */
    public function getPasivniVyhledavani()
    {
        return $this->PasivniVyhledavani;
    }
    /**
     * Set PasivniVyhledavani value
     * @param string $pasivniVyhledavani
     * @return \StructType\SlevyHAV
     */
    public function setPasivniVyhledavani($pasivniVyhledavani = null)
    {
        // validation for constraint: string
        if (!is_null($pasivniVyhledavani) && !is_string($pasivniVyhledavani)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pasivniVyhledavani)), __LINE__);
        }
        $this->PasivniVyhledavani = $pasivniVyhledavani;
        return $this;
    }
    /**
     * Get PocetMesicu value
     * @return int|null
     */
    public function getPocetMesicu()
    {
        return $this->PocetMesicu;
    }
    /**
     * Set PocetMesicu value
     * @param int $pocetMesicu
     * @return \StructType\SlevyHAV
     */
    public function setPocetMesicu($pocetMesicu = null)
    {
        // validation for constraint: int
        if (!is_null($pocetMesicu) && !is_numeric($pocetMesicu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pocetMesicu)), __LINE__);
        }
        $this->PocetMesicu = $pocetMesicu;
        return $this;
    }
    /**
     * Get UplatnitBonusPOV value
     * @return string|null
     */
    public function getUplatnitBonusPOV()
    {
        return $this->UplatnitBonusPOV;
    }
    /**
     * Set UplatnitBonusPOV value
     * @param string $uplatnitBonusPOV
     * @return \StructType\SlevyHAV
     */
    public function setUplatnitBonusPOV($uplatnitBonusPOV = null)
    {
        // validation for constraint: string
        if (!is_null($uplatnitBonusPOV) && !is_string($uplatnitBonusPOV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uplatnitBonusPOV)), __LINE__);
        }
        $this->UplatnitBonusPOV = $uplatnitBonusPOV;
        return $this;
    }
    /**
     * Get ZabezpMech value
     * @return string|null
     */
    public function getZabezpMech()
    {
        return $this->ZabezpMech;
    }
    /**
     * Set ZabezpMech value
     * @param string $zabezpMech
     * @return \StructType\SlevyHAV
     */
    public function setZabezpMech($zabezpMech = null)
    {
        // validation for constraint: string
        if (!is_null($zabezpMech) && !is_string($zabezpMech)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zabezpMech)), __LINE__);
        }
        $this->ZabezpMech = $zabezpMech;
        return $this;
    }
    /**
     * Get ZnaceniSkel value
     * @return string|null
     */
    public function getZnaceniSkel()
    {
        return $this->ZnaceniSkel;
    }
    /**
     * Set ZnaceniSkel value
     * @param string $znaceniSkel
     * @return \StructType\SlevyHAV
     */
    public function setZnaceniSkel($znaceniSkel = null)
    {
        // validation for constraint: string
        if (!is_null($znaceniSkel) && !is_string($znaceniSkel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($znaceniSkel)), __LINE__);
        }
        $this->ZnaceniSkel = $znaceniSkel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SlevyHAV
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
