<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Pojisteni StructType
 * @subpackage Structs
 */
class Pojisteni extends AbstractStructBase
{
    /**
     * The KodPojisteni
     * @var string
     */
    public $KodPojisteni;
    /**
     * The KodProhlidky
     * @var string
     */
    public $KodProhlidky;
    /**
     * The KodRozliseni
     * @var string
     */
    public $KodRozliseni;
    /**
     * The Limit
     * @var int
     */
    public $Limit;
    /**
     * The RozhodnaDoba
     * @var int
     */
    public $RozhodnaDoba;
    /**
     * The Sjednano
     * @var string
     */
    public $Sjednano;
    /**
     * The SpolNejmene
     * @var int
     */
    public $SpolNejmene;
    /**
     * The SpolProc
     * @var int
     */
    public $SpolProc;
    /**
     * Constructor method for Pojisteni
     * @uses Pojisteni::setKodPojisteni()
     * @uses Pojisteni::setKodProhlidky()
     * @uses Pojisteni::setKodRozliseni()
     * @uses Pojisteni::setLimit()
     * @uses Pojisteni::setRozhodnaDoba()
     * @uses Pojisteni::setSjednano()
     * @uses Pojisteni::setSpolNejmene()
     * @uses Pojisteni::setSpolProc()
     * @param string $kodPojisteni
     * @param string $kodProhlidky
     * @param string $kodRozliseni
     * @param int $limit
     * @param int $rozhodnaDoba
     * @param string $sjednano
     * @param int $spolNejmene
     * @param int $spolProc
     */
    public function __construct($kodPojisteni = null, $kodProhlidky = null, $kodRozliseni = null, $limit = null, $rozhodnaDoba = null, $sjednano = null, $spolNejmene = null, $spolProc = null)
    {
        $this
            ->setKodPojisteni($kodPojisteni)
            ->setKodProhlidky($kodProhlidky)
            ->setKodRozliseni($kodRozliseni)
            ->setLimit($limit)
            ->setRozhodnaDoba($rozhodnaDoba)
            ->setSjednano($sjednano)
            ->setSpolNejmene($spolNejmene)
            ->setSpolProc($spolProc);
    }
    /**
     * Get KodPojisteni value
     * @return string|null
     */
    public function getKodPojisteni()
    {
        return $this->KodPojisteni;
    }
    /**
     * Set KodPojisteni value
     * @param string $kodPojisteni
     * @return \StructType\Pojisteni
     */
    public function setKodPojisteni($kodPojisteni = null)
    {
        // validation for constraint: string
        if (!is_null($kodPojisteni) && !is_string($kodPojisteni)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kodPojisteni)), __LINE__);
        }
        $this->KodPojisteni = $kodPojisteni;
        return $this;
    }
    /**
     * Get KodProhlidky value
     * @return string|null
     */
    public function getKodProhlidky()
    {
        return $this->KodProhlidky;
    }
    /**
     * Set KodProhlidky value
     * @param string $kodProhlidky
     * @return \StructType\Pojisteni
     */
    public function setKodProhlidky($kodProhlidky = null)
    {
        // validation for constraint: string
        if (!is_null($kodProhlidky) && !is_string($kodProhlidky)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kodProhlidky)), __LINE__);
        }
        $this->KodProhlidky = $kodProhlidky;
        return $this;
    }
    /**
     * Get KodRozliseni value
     * @return string|null
     */
    public function getKodRozliseni()
    {
        return $this->KodRozliseni;
    }
    /**
     * Set KodRozliseni value
     * @param string $kodRozliseni
     * @return \StructType\Pojisteni
     */
    public function setKodRozliseni($kodRozliseni = null)
    {
        // validation for constraint: string
        if (!is_null($kodRozliseni) && !is_string($kodRozliseni)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kodRozliseni)), __LINE__);
        }
        $this->KodRozliseni = $kodRozliseni;
        return $this;
    }
    /**
     * Get Limit value
     * @return int|null
     */
    public function getLimit()
    {
        return $this->Limit;
    }
    /**
     * Set Limit value
     * @param int $limit
     * @return \StructType\Pojisteni
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        $this->Limit = $limit;
        return $this;
    }
    /**
     * Get RozhodnaDoba value
     * @return int|null
     */
    public function getRozhodnaDoba()
    {
        return $this->RozhodnaDoba;
    }
    /**
     * Set RozhodnaDoba value
     * @param int $rozhodnaDoba
     * @return \StructType\Pojisteni
     */
    public function setRozhodnaDoba($rozhodnaDoba = null)
    {
        // validation for constraint: int
        if (!is_null($rozhodnaDoba) && !is_numeric($rozhodnaDoba)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rozhodnaDoba)), __LINE__);
        }
        $this->RozhodnaDoba = $rozhodnaDoba;
        return $this;
    }
    /**
     * Get Sjednano value
     * @return string|null
     */
    public function getSjednano()
    {
        return $this->Sjednano;
    }
    /**
     * Set Sjednano value
     * @param string $sjednano
     * @return \StructType\Pojisteni
     */
    public function setSjednano($sjednano = null)
    {
        // validation for constraint: string
        if (!is_null($sjednano) && !is_string($sjednano)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sjednano)), __LINE__);
        }
        $this->Sjednano = $sjednano;
        return $this;
    }
    /**
     * Get SpolNejmene value
     * @return int|null
     */
    public function getSpolNejmene()
    {
        return $this->SpolNejmene;
    }
    /**
     * Set SpolNejmene value
     * @param int $spolNejmene
     * @return \StructType\Pojisteni
     */
    public function setSpolNejmene($spolNejmene = null)
    {
        // validation for constraint: int
        if (!is_null($spolNejmene) && !is_numeric($spolNejmene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($spolNejmene)), __LINE__);
        }
        $this->SpolNejmene = $spolNejmene;
        return $this;
    }
    /**
     * Get SpolProc value
     * @return int|null
     */
    public function getSpolProc()
    {
        return $this->SpolProc;
    }
    /**
     * Set SpolProc value
     * @param int $spolProc
     * @return \StructType\Pojisteni
     */
    public function setSpolProc($spolProc = null)
    {
        // validation for constraint: int
        if (!is_null($spolProc) && !is_numeric($spolProc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($spolProc)), __LINE__);
        }
        $this->SpolProc = $spolProc;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Pojisteni
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
