<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlatbaOut StructType
 * @subpackage Structs
 */
class PlatbaOut extends AbstractStructBase
{
    /**
     * The CelkovaCastka
     * @var int
     */
    public $CelkovaCastka;
    /**
     * The PlatbaOutChyby
     * Meta informations extracted from the WSDL
     * - arrayType: tns:PlatbaOutChyby[]
     * - ref: SOAP-ENC:arrayType
     * @var \StructType\PlatbaOutChyby[]
     */
    public $PlatbaOutChyby;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The VS
     * @var string
     */
    public $VS;
    /**
     * Constructor method for PlatbaOut
     * @uses PlatbaOut::setCelkovaCastka()
     * @uses PlatbaOut::setPlatbaOutChyby()
     * @uses PlatbaOut::setStatus()
     * @uses PlatbaOut::setVS()
     * @param int $celkovaCastka
     * @param \StructType\PlatbaOutChyby[] $platbaOutChyby
     * @param string $status
     * @param string $vS
     */
    public function __construct($celkovaCastka = null, array $platbaOutChyby = array(), $status = null, $vS = null)
    {
        $this
            ->setCelkovaCastka($celkovaCastka)
            ->setPlatbaOutChyby($platbaOutChyby)
            ->setStatus($status)
            ->setVS($vS);
    }
    /**
     * Get CelkovaCastka value
     * @return int|null
     */
    public function getCelkovaCastka()
    {
        return $this->CelkovaCastka;
    }
    /**
     * Set CelkovaCastka value
     * @param int $celkovaCastka
     * @return \StructType\PlatbaOut
     */
    public function setCelkovaCastka($celkovaCastka = null)
    {
        // validation for constraint: int
        if (!is_null($celkovaCastka) && !is_numeric($celkovaCastka)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($celkovaCastka)), __LINE__);
        }
        $this->CelkovaCastka = $celkovaCastka;
        return $this;
    }
    /**
     * Get PlatbaOutChyby value
     * @return \StructType\PlatbaOutChyby[]|null
     */
    public function getPlatbaOutChyby()
    {
        return $this->PlatbaOutChyby;
    }
    /**
     * Set PlatbaOutChyby value
     * @throws \InvalidArgumentException
     * @param \StructType\PlatbaOutChyby[] $platbaOutChyby
     * @return \StructType\PlatbaOut
     */
    public function setPlatbaOutChyby(array $platbaOutChyby = array())
    {
        foreach ($platbaOutChyby as $platbaOutPlatbaOutChybyItem) {
            // validation for constraint: itemType
            if (!$platbaOutPlatbaOutChybyItem instanceof \StructType\PlatbaOutChyby) {
                throw new \InvalidArgumentException(sprintf('The PlatbaOutChyby property can only contain items of \StructType\PlatbaOutChyby, "%s" given', is_object($platbaOutPlatbaOutChybyItem) ? get_class($platbaOutPlatbaOutChybyItem) : gettype($platbaOutPlatbaOutChybyItem)), __LINE__);
            }
        }
        $this->PlatbaOutChyby = $platbaOutChyby;
        return $this;
    }
    /**
     * Add item to PlatbaOutChyby value
     * @throws \InvalidArgumentException
     * @param \StructType\PlatbaOutChyby $item
     * @return \StructType\PlatbaOut
     */
    public function addToPlatbaOutChyby(\StructType\PlatbaOutChyby $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PlatbaOutChyby) {
            throw new \InvalidArgumentException(sprintf('The PlatbaOutChyby property can only contain items of \StructType\PlatbaOutChyby, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PlatbaOutChyby[] = $item;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\PlatbaOut
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get VS value
     * @return string|null
     */
    public function getVS()
    {
        return $this->VS;
    }
    /**
     * Set VS value
     * @param string $vS
     * @return \StructType\PlatbaOut
     */
    public function setVS($vS = null)
    {
        // validation for constraint: string
        if (!is_null($vS) && !is_string($vS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vS)), __LINE__);
        }
        $this->VS = $vS;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PlatbaOut
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
