<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for POV StructType
 * @subpackage Structs
 */
class POV extends AbstractStructBase
{
    /**
     * The PSP
     * @var \StructType\PSP
     */
    public $PSP;
    /**
     * The SlevyPOV
     * @var \StructType\SlevyPOV
     */
    public $SlevyPOV;
    /**
     * The TarifniSkupinaPojPOV
     * @var string
     */
    public $TarifniSkupinaPojPOV;
    /**
     * Constructor method for POV
     * @uses POV::setPSP()
     * @uses POV::setSlevyPOV()
     * @uses POV::setTarifniSkupinaPojPOV()
     * @param \StructType\PSP $pSP
     * @param \StructType\SlevyPOV $slevyPOV
     * @param string $tarifniSkupinaPojPOV
     */
    public function __construct(\StructType\PSP $pSP = null, \StructType\SlevyPOV $slevyPOV = null, $tarifniSkupinaPojPOV = null)
    {
        $this
            ->setPSP($pSP)
            ->setSlevyPOV($slevyPOV)
            ->setTarifniSkupinaPojPOV($tarifniSkupinaPojPOV);
    }
    /**
     * Get PSP value
     * @return \StructType\PSP|null
     */
    public function getPSP()
    {
        return $this->PSP;
    }
    /**
     * Set PSP value
     * @param \StructType\PSP $pSP
     * @return \StructType\POV
     */
    public function setPSP(\StructType\PSP $pSP = null)
    {
        $this->PSP = $pSP;
        return $this;
    }
    /**
     * Get SlevyPOV value
     * @return \StructType\SlevyPOV|null
     */
    public function getSlevyPOV()
    {
        return $this->SlevyPOV;
    }
    /**
     * Set SlevyPOV value
     * @param \StructType\SlevyPOV $slevyPOV
     * @return \StructType\POV
     */
    public function setSlevyPOV(\StructType\SlevyPOV $slevyPOV = null)
    {
        $this->SlevyPOV = $slevyPOV;
        return $this;
    }
    /**
     * Get TarifniSkupinaPojPOV value
     * @return string|null
     */
    public function getTarifniSkupinaPojPOV()
    {
        return $this->TarifniSkupinaPojPOV;
    }
    /**
     * Set TarifniSkupinaPojPOV value
     * @param string $tarifniSkupinaPojPOV
     * @return \StructType\POV
     */
    public function setTarifniSkupinaPojPOV($tarifniSkupinaPojPOV = null)
    {
        // validation for constraint: string
        if (!is_null($tarifniSkupinaPojPOV) && !is_string($tarifniSkupinaPojPOV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tarifniSkupinaPojPOV)), __LINE__);
        }
        $this->TarifniSkupinaPojPOV = $tarifniSkupinaPojPOV;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\POV
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
