<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Platba ServiceType
 * @subpackage Services
 */
class Platba extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PlatbaPS
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $platbaIn
     * @return \StructType\PlatbaOut|bool
     */
    public function PlatbaPS($platbaIn)
    {
        try {
            $this->setResult(self::getSoapClient()->PlatbaPS($platbaIn));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PlatbaOut
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
