<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ZelenaKarta StructType
 * @subpackage Structs
 */
class ZelenaKarta extends AbstractStructBase
{
    /**
     * The CisloZK
     * @var string
     */
    public $CisloZK;
    /**
     * The DatumVystaveni
     * @var int
     */
    public $DatumVystaveni;
    /**
     * The PlatnostZKDo
     * @var int
     */
    public $PlatnostZKDo;
    /**
     * The PlatnostZKOd
     * @var int
     */
    public $PlatnostZKOd;
    /**
     * Constructor method for ZelenaKarta
     * @uses ZelenaKarta::setCisloZK()
     * @uses ZelenaKarta::setDatumVystaveni()
     * @uses ZelenaKarta::setPlatnostZKDo()
     * @uses ZelenaKarta::setPlatnostZKOd()
     * @param string $cisloZK
     * @param int $datumVystaveni
     * @param int $platnostZKDo
     * @param int $platnostZKOd
     */
    public function __construct($cisloZK = null, $datumVystaveni = null, $platnostZKDo = null, $platnostZKOd = null)
    {
        $this
            ->setCisloZK($cisloZK)
            ->setDatumVystaveni($datumVystaveni)
            ->setPlatnostZKDo($platnostZKDo)
            ->setPlatnostZKOd($platnostZKOd);
    }
    /**
     * Get CisloZK value
     * @return string|null
     */
    public function getCisloZK()
    {
        return $this->CisloZK;
    }
    /**
     * Set CisloZK value
     * @param string $cisloZK
     * @return \StructType\ZelenaKarta
     */
    public function setCisloZK($cisloZK = null)
    {
        // validation for constraint: string
        if (!is_null($cisloZK) && !is_string($cisloZK)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cisloZK)), __LINE__);
        }
        $this->CisloZK = $cisloZK;
        return $this;
    }
    /**
     * Get DatumVystaveni value
     * @return int|null
     */
    public function getDatumVystaveni()
    {
        return $this->DatumVystaveni;
    }
    /**
     * Set DatumVystaveni value
     * @param int $datumVystaveni
     * @return \StructType\ZelenaKarta
     */
    public function setDatumVystaveni($datumVystaveni = null)
    {
        // validation for constraint: int
        if (!is_null($datumVystaveni) && !is_numeric($datumVystaveni)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($datumVystaveni)), __LINE__);
        }
        $this->DatumVystaveni = $datumVystaveni;
        return $this;
    }
    /**
     * Get PlatnostZKDo value
     * @return int|null
     */
    public function getPlatnostZKDo()
    {
        return $this->PlatnostZKDo;
    }
    /**
     * Set PlatnostZKDo value
     * @param int $platnostZKDo
     * @return \StructType\ZelenaKarta
     */
    public function setPlatnostZKDo($platnostZKDo = null)
    {
        // validation for constraint: int
        if (!is_null($platnostZKDo) && !is_numeric($platnostZKDo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($platnostZKDo)), __LINE__);
        }
        $this->PlatnostZKDo = $platnostZKDo;
        return $this;
    }
    /**
     * Get PlatnostZKOd value
     * @return int|null
     */
    public function getPlatnostZKOd()
    {
        return $this->PlatnostZKOd;
    }
    /**
     * Set PlatnostZKOd value
     * @param int $platnostZKOd
     * @return \StructType\ZelenaKarta
     */
    public function setPlatnostZKOd($platnostZKOd = null)
    {
        // validation for constraint: int
        if (!is_null($platnostZKOd) && !is_numeric($platnostZKOd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($platnostZKOd)), __LINE__);
        }
        $this->PlatnostZKOd = $platnostZKOd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ZelenaKarta
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
