<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ZdrojovaSmlouva StructType
 * @subpackage Structs
 */
class ZdrojovaSmlouva extends AbstractStructBase
{
    /**
     * The CisloSmlouvy
     * @var string
     */
    public $CisloSmlouvy;
    /**
     * The KodPojistitele
     * @var string
     */
    public $KodPojistitele;
    /**
     * The PoradiVozidla
     * @var int
     */
    public $PoradiVozidla;
    /**
     * Constructor method for ZdrojovaSmlouva
     * @uses ZdrojovaSmlouva::setCisloSmlouvy()
     * @uses ZdrojovaSmlouva::setKodPojistitele()
     * @uses ZdrojovaSmlouva::setPoradiVozidla()
     * @param string $cisloSmlouvy
     * @param string $kodPojistitele
     * @param int $poradiVozidla
     */
    public function __construct($cisloSmlouvy = null, $kodPojistitele = null, $poradiVozidla = null)
    {
        $this
            ->setCisloSmlouvy($cisloSmlouvy)
            ->setKodPojistitele($kodPojistitele)
            ->setPoradiVozidla($poradiVozidla);
    }
    /**
     * Get CisloSmlouvy value
     * @return string|null
     */
    public function getCisloSmlouvy()
    {
        return $this->CisloSmlouvy;
    }
    /**
     * Set CisloSmlouvy value
     * @param string $cisloSmlouvy
     * @return \StructType\ZdrojovaSmlouva
     */
    public function setCisloSmlouvy($cisloSmlouvy = null)
    {
        // validation for constraint: string
        if (!is_null($cisloSmlouvy) && !is_string($cisloSmlouvy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cisloSmlouvy)), __LINE__);
        }
        $this->CisloSmlouvy = $cisloSmlouvy;
        return $this;
    }
    /**
     * Get KodPojistitele value
     * @return string|null
     */
    public function getKodPojistitele()
    {
        return $this->KodPojistitele;
    }
    /**
     * Set KodPojistitele value
     * @param string $kodPojistitele
     * @return \StructType\ZdrojovaSmlouva
     */
    public function setKodPojistitele($kodPojistitele = null)
    {
        // validation for constraint: string
        if (!is_null($kodPojistitele) && !is_string($kodPojistitele)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kodPojistitele)), __LINE__);
        }
        $this->KodPojistitele = $kodPojistitele;
        return $this;
    }
    /**
     * Get PoradiVozidla value
     * @return int|null
     */
    public function getPoradiVozidla()
    {
        return $this->PoradiVozidla;
    }
    /**
     * Set PoradiVozidla value
     * @param int $poradiVozidla
     * @return \StructType\ZdrojovaSmlouva
     */
    public function setPoradiVozidla($poradiVozidla = null)
    {
        // validation for constraint: int
        if (!is_null($poradiVozidla) && !is_numeric($poradiVozidla)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($poradiVozidla)), __LINE__);
        }
        $this->PoradiVozidla = $poradiVozidla;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ZdrojovaSmlouva
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
