<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PSP StructType
 * @subpackage Structs
 */
class PSP extends AbstractStructBase
{
    /**
     * The NositelPSP
     * @var string
     */
    public $NositelPSP;
    /**
     * The RozhodnaDoba
     * @var int
     */
    public $RozhodnaDoba;
    /**
     * The ZdrojovaSmlouva
     * @var \StructType\ZdrojovaSmlouva
     */
    public $ZdrojovaSmlouva;
    /**
     * Constructor method for PSP
     * @uses PSP::setNositelPSP()
     * @uses PSP::setRozhodnaDoba()
     * @uses PSP::setZdrojovaSmlouva()
     * @param string $nositelPSP
     * @param int $rozhodnaDoba
     * @param \StructType\ZdrojovaSmlouva $zdrojovaSmlouva
     */
    public function __construct($nositelPSP = null, $rozhodnaDoba = null, \StructType\ZdrojovaSmlouva $zdrojovaSmlouva = null)
    {
        $this
            ->setNositelPSP($nositelPSP)
            ->setRozhodnaDoba($rozhodnaDoba)
            ->setZdrojovaSmlouva($zdrojovaSmlouva);
    }
    /**
     * Get NositelPSP value
     * @return string|null
     */
    public function getNositelPSP()
    {
        return $this->NositelPSP;
    }
    /**
     * Set NositelPSP value
     * @param string $nositelPSP
     * @return \StructType\PSP
     */
    public function setNositelPSP($nositelPSP = null)
    {
        // validation for constraint: string
        if (!is_null($nositelPSP) && !is_string($nositelPSP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nositelPSP)), __LINE__);
        }
        $this->NositelPSP = $nositelPSP;
        return $this;
    }
    /**
     * Get RozhodnaDoba value
     * @return int|null
     */
    public function getRozhodnaDoba()
    {
        return $this->RozhodnaDoba;
    }
    /**
     * Set RozhodnaDoba value
     * @param int $rozhodnaDoba
     * @return \StructType\PSP
     */
    public function setRozhodnaDoba($rozhodnaDoba = null)
    {
        // validation for constraint: int
        if (!is_null($rozhodnaDoba) && !is_numeric($rozhodnaDoba)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rozhodnaDoba)), __LINE__);
        }
        $this->RozhodnaDoba = $rozhodnaDoba;
        return $this;
    }
    /**
     * Get ZdrojovaSmlouva value
     * @return \StructType\ZdrojovaSmlouva|null
     */
    public function getZdrojovaSmlouva()
    {
        return $this->ZdrojovaSmlouva;
    }
    /**
     * Set ZdrojovaSmlouva value
     * @param \StructType\ZdrojovaSmlouva $zdrojovaSmlouva
     * @return \StructType\PSP
     */
    public function setZdrojovaSmlouva(\StructType\ZdrojovaSmlouva $zdrojovaSmlouva = null)
    {
        $this->ZdrojovaSmlouva = $zdrojovaSmlouva;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PSP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
