<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Adresa StructType
 * @subpackage Structs
 */
class Adresa extends AbstractStructBase
{
    /**
     * The CastObce
     * @var string
     */
    public $CastObce;
    /**
     * The CisloDomu
     * @var string
     */
    public $CisloDomu;
    /**
     * The MestskaCast
     * @var string
     */
    public $MestskaCast;
    /**
     * The Obec
     * @var string
     */
    public $Obec;
    /**
     * The PSC
     * @var string
     */
    public $PSC;
    /**
     * The Stat
     * @var string
     */
    public $Stat;
    /**
     * The UIRid
     * @var int
     */
    public $UIRid;
    /**
     * The Ulice
     * @var string
     */
    public $Ulice;
    /**
     * Constructor method for Adresa
     * @uses Adresa::setCastObce()
     * @uses Adresa::setCisloDomu()
     * @uses Adresa::setMestskaCast()
     * @uses Adresa::setObec()
     * @uses Adresa::setPSC()
     * @uses Adresa::setStat()
     * @uses Adresa::setUIRid()
     * @uses Adresa::setUlice()
     * @param string $castObce
     * @param string $cisloDomu
     * @param string $mestskaCast
     * @param string $obec
     * @param string $pSC
     * @param string $stat
     * @param int $uIRid
     * @param string $ulice
     */
    public function __construct($castObce = null, $cisloDomu = null, $mestskaCast = null, $obec = null, $pSC = null, $stat = null, $uIRid = null, $ulice = null)
    {
        $this
            ->setCastObce($castObce)
            ->setCisloDomu($cisloDomu)
            ->setMestskaCast($mestskaCast)
            ->setObec($obec)
            ->setPSC($pSC)
            ->setStat($stat)
            ->setUIRid($uIRid)
            ->setUlice($ulice);
    }
    /**
     * Get CastObce value
     * @return string|null
     */
    public function getCastObce()
    {
        return $this->CastObce;
    }
    /**
     * Set CastObce value
     * @param string $castObce
     * @return \StructType\Adresa
     */
    public function setCastObce($castObce = null)
    {
        // validation for constraint: string
        if (!is_null($castObce) && !is_string($castObce)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($castObce)), __LINE__);
        }
        $this->CastObce = $castObce;
        return $this;
    }
    /**
     * Get CisloDomu value
     * @return string|null
     */
    public function getCisloDomu()
    {
        return $this->CisloDomu;
    }
    /**
     * Set CisloDomu value
     * @param string $cisloDomu
     * @return \StructType\Adresa
     */
    public function setCisloDomu($cisloDomu = null)
    {
        // validation for constraint: string
        if (!is_null($cisloDomu) && !is_string($cisloDomu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cisloDomu)), __LINE__);
        }
        $this->CisloDomu = $cisloDomu;
        return $this;
    }
    /**
     * Get MestskaCast value
     * @return string|null
     */
    public function getMestskaCast()
    {
        return $this->MestskaCast;
    }
    /**
     * Set MestskaCast value
     * @param string $mestskaCast
     * @return \StructType\Adresa
     */
    public function setMestskaCast($mestskaCast = null)
    {
        // validation for constraint: string
        if (!is_null($mestskaCast) && !is_string($mestskaCast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mestskaCast)), __LINE__);
        }
        $this->MestskaCast = $mestskaCast;
        return $this;
    }
    /**
     * Get Obec value
     * @return string|null
     */
    public function getObec()
    {
        return $this->Obec;
    }
    /**
     * Set Obec value
     * @param string $obec
     * @return \StructType\Adresa
     */
    public function setObec($obec = null)
    {
        // validation for constraint: string
        if (!is_null($obec) && !is_string($obec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($obec)), __LINE__);
        }
        $this->Obec = $obec;
        return $this;
    }
    /**
     * Get PSC value
     * @return string|null
     */
    public function getPSC()
    {
        return $this->PSC;
    }
    /**
     * Set PSC value
     * @param string $pSC
     * @return \StructType\Adresa
     */
    public function setPSC($pSC = null)
    {
        // validation for constraint: string
        if (!is_null($pSC) && !is_string($pSC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pSC)), __LINE__);
        }
        $this->PSC = $pSC;
        return $this;
    }
    /**
     * Get Stat value
     * @return string|null
     */
    public function getStat()
    {
        return $this->Stat;
    }
    /**
     * Set Stat value
     * @param string $stat
     * @return \StructType\Adresa
     */
    public function setStat($stat = null)
    {
        // validation for constraint: string
        if (!is_null($stat) && !is_string($stat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stat)), __LINE__);
        }
        $this->Stat = $stat;
        return $this;
    }
    /**
     * Get UIRid value
     * @return int|null
     */
    public function getUIRid()
    {
        return $this->UIRid;
    }
    /**
     * Set UIRid value
     * @param int $uIRid
     * @return \StructType\Adresa
     */
    public function setUIRid($uIRid = null)
    {
        // validation for constraint: int
        if (!is_null($uIRid) && !is_numeric($uIRid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($uIRid)), __LINE__);
        }
        $this->UIRid = $uIRid;
        return $this;
    }
    /**
     * Get Ulice value
     * @return string|null
     */
    public function getUlice()
    {
        return $this->Ulice;
    }
    /**
     * Set Ulice value
     * @param string $ulice
     * @return \StructType\Adresa
     */
    public function setUlice($ulice = null)
    {
        // validation for constraint: string
        if (!is_null($ulice) && !is_string($ulice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ulice)), __LINE__);
        }
        $this->Ulice = $ulice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Adresa
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
