<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for OZ ServiceType
 * @subpackage Services
 */
class OZ extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named oZmenaPS
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Smlouva $smlouva
     * @return \StructType\OutNS|bool
     */
    public function oZmenaPS(\StructType\Smlouva $smlouva)
    {
        try {
            $this->setResult(self::getSoapClient()->oZmenaPS($smlouva));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OutNS
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
