<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://veris.bizdata.cz:9080/IS_SLA_GP1/service.php?class=InsuranceService&wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://veris.bizdata.cz:9080/IS_SLA_GP1/service.php?class=InsuranceService&wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Adresa ServiceType
 */
$adresa = new \ServiceType\Adresa($options);
/**
 * Sample call for AdresaUIR operation/method
 */
if ($adresa->AdresaUIR($Adresa) !== false) {
    print_r($adresa->getResult());
} else {
    print_r($adresa->getLastError());
}
/**
 * Samples for Nova ServiceType
 */
$nova = new \ServiceType\Nova($options);
/**
 * Sample call for NovaPS operation/method
 */
if ($nova->NovaPS(new \StructType\Smlouva()) !== false) {
    print_r($nova->getResult());
} else {
    print_r($nova->getLastError());
}
/**
 * Samples for Platba ServiceType
 */
$platba = new \ServiceType\Platba($options);
/**
 * Sample call for PlatbaPS operation/method
 */
if ($platba->PlatbaPS($PlatbaIn) !== false) {
    print_r($platba->getResult());
} else {
    print_r($platba->getLastError());
}
/**
 * Samples for Storno ServiceType
 */
$storno = new \ServiceType\Storno($options);
/**
 * Sample call for StornoPS operation/method
 */
if ($storno->StornoPS(new \StructType\StornoIn()) !== false) {
    print_r($storno->getResult());
} else {
    print_r($storno->getLastError());
}
/**
 * Samples for Test ServiceType
 */
$test = new \ServiceType\Test($options);
/**
 * Sample call for Test operation/method
 */
if ($test->Test() !== false) {
    print_r($test->getResult());
} else {
    print_r($test->getLastError());
}
/**
 * Samples for Ukonceni ServiceType
 */
$ukonceni = new \ServiceType\Ukonceni($options);
/**
 * Sample call for UkonceniPS operation/method
 */
if ($ukonceni->UkonceniPS(new \StructType\UkonceniIn()) !== false) {
    print_r($ukonceni->getResult());
} else {
    print_r($ukonceni->getLastError());
}
/**
 * Samples for Zmena ServiceType
 */
$zmena = new \ServiceType\Zmena($options);
/**
 * Sample call for ZmenaPS operation/method
 */
if ($zmena->ZmenaPS(new \StructType\Smlouva()) !== false) {
    print_r($zmena->getResult());
} else {
    print_r($zmena->getLastError());
}
/**
 * Sample call for ZmenaPolPS operation/method
 */
if ($zmena->ZmenaPolPS(new \StructType\ZmenaPolIn()) !== false) {
    print_r($zmena->getResult());
} else {
    print_r($zmena->getLastError());
}
/**
 * Samples for OZ ServiceType
 */
$oZ = new \ServiceType\OZ($options);
/**
 * Sample call for oZmenaPS operation/method
 */
if ($oZ->oZmenaPS(new \StructType\Smlouva()) !== false) {
    print_r($oZ->getResult());
} else {
    print_r($oZ->getLastError());
}
