<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Subjekt StructType
 * @subpackage Structs
 */
class Subjekt extends AbstractStructBase
{
    /**
     * The Adresa
     * @var \StructType\Adresa
     */
    public $Adresa;
    /**
     * The DatumNarozeni
     * @var string
     */
    public $DatumNarozeni;
    /**
     * The Email
     * @var string
     */
    public $Email;
    /**
     * The IC
     * @var int
     */
    public $IC;
    /**
     * The Jmeno
     * @var string
     */
    public $Jmeno;
    /**
     * The Mobil
     * @var string
     */
    public $Mobil;
    /**
     * The NazevFirmy
     * @var string
     */
    public $NazevFirmy;
    /**
     * The Prijmeni
     * @var string
     */
    public $Prijmeni;
    /**
     * The RC
     * @var string
     */
    public $RC;
    /**
     * The StatPrislusnost
     * @var string
     */
    public $StatPrislusnost;
    /**
     * The Telefon
     * @var string
     */
    public $Telefon;
    /**
     * The TitulPred
     * @var string
     */
    public $TitulPred;
    /**
     * The TypSubjektu
     * @var string
     */
    public $TypSubjektu;
    /**
     * Constructor method for Subjekt
     * @uses Subjekt::setAdresa()
     * @uses Subjekt::setDatumNarozeni()
     * @uses Subjekt::setEmail()
     * @uses Subjekt::setIC()
     * @uses Subjekt::setJmeno()
     * @uses Subjekt::setMobil()
     * @uses Subjekt::setNazevFirmy()
     * @uses Subjekt::setPrijmeni()
     * @uses Subjekt::setRC()
     * @uses Subjekt::setStatPrislusnost()
     * @uses Subjekt::setTelefon()
     * @uses Subjekt::setTitulPred()
     * @uses Subjekt::setTypSubjektu()
     * @param \StructType\Adresa $adresa
     * @param string $datumNarozeni
     * @param string $email
     * @param int $iC
     * @param string $jmeno
     * @param string $mobil
     * @param string $nazevFirmy
     * @param string $prijmeni
     * @param string $rC
     * @param string $statPrislusnost
     * @param string $telefon
     * @param string $titulPred
     * @param string $typSubjektu
     */
    public function __construct(\StructType\Adresa $adresa = null, $datumNarozeni = null, $email = null, $iC = null, $jmeno = null, $mobil = null, $nazevFirmy = null, $prijmeni = null, $rC = null, $statPrislusnost = null, $telefon = null, $titulPred = null, $typSubjektu = null)
    {
        $this
            ->setAdresa($adresa)
            ->setDatumNarozeni($datumNarozeni)
            ->setEmail($email)
            ->setIC($iC)
            ->setJmeno($jmeno)
            ->setMobil($mobil)
            ->setNazevFirmy($nazevFirmy)
            ->setPrijmeni($prijmeni)
            ->setRC($rC)
            ->setStatPrislusnost($statPrislusnost)
            ->setTelefon($telefon)
            ->setTitulPred($titulPred)
            ->setTypSubjektu($typSubjektu);
    }
    /**
     * Get Adresa value
     * @return \StructType\Adresa|null
     */
    public function getAdresa()
    {
        return $this->Adresa;
    }
    /**
     * Set Adresa value
     * @param \StructType\Adresa $adresa
     * @return \StructType\Subjekt
     */
    public function setAdresa(\StructType\Adresa $adresa = null)
    {
        $this->Adresa = $adresa;
        return $this;
    }
    /**
     * Get DatumNarozeni value
     * @return string|null
     */
    public function getDatumNarozeni()
    {
        return $this->DatumNarozeni;
    }
    /**
     * Set DatumNarozeni value
     * @param string $datumNarozeni
     * @return \StructType\Subjekt
     */
    public function setDatumNarozeni($datumNarozeni = null)
    {
        // validation for constraint: string
        if (!is_null($datumNarozeni) && !is_string($datumNarozeni)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datumNarozeni)), __LINE__);
        }
        $this->DatumNarozeni = $datumNarozeni;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\Subjekt
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get IC value
     * @return int|null
     */
    public function getIC()
    {
        return $this->IC;
    }
    /**
     * Set IC value
     * @param int $iC
     * @return \StructType\Subjekt
     */
    public function setIC($iC = null)
    {
        // validation for constraint: int
        if (!is_null($iC) && !is_numeric($iC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iC)), __LINE__);
        }
        $this->IC = $iC;
        return $this;
    }
    /**
     * Get Jmeno value
     * @return string|null
     */
    public function getJmeno()
    {
        return $this->Jmeno;
    }
    /**
     * Set Jmeno value
     * @param string $jmeno
     * @return \StructType\Subjekt
     */
    public function setJmeno($jmeno = null)
    {
        // validation for constraint: string
        if (!is_null($jmeno) && !is_string($jmeno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($jmeno)), __LINE__);
        }
        $this->Jmeno = $jmeno;
        return $this;
    }
    /**
     * Get Mobil value
     * @return string|null
     */
    public function getMobil()
    {
        return $this->Mobil;
    }
    /**
     * Set Mobil value
     * @param string $mobil
     * @return \StructType\Subjekt
     */
    public function setMobil($mobil = null)
    {
        // validation for constraint: string
        if (!is_null($mobil) && !is_string($mobil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mobil)), __LINE__);
        }
        $this->Mobil = $mobil;
        return $this;
    }
    /**
     * Get NazevFirmy value
     * @return string|null
     */
    public function getNazevFirmy()
    {
        return $this->NazevFirmy;
    }
    /**
     * Set NazevFirmy value
     * @param string $nazevFirmy
     * @return \StructType\Subjekt
     */
    public function setNazevFirmy($nazevFirmy = null)
    {
        // validation for constraint: string
        if (!is_null($nazevFirmy) && !is_string($nazevFirmy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nazevFirmy)), __LINE__);
        }
        $this->NazevFirmy = $nazevFirmy;
        return $this;
    }
    /**
     * Get Prijmeni value
     * @return string|null
     */
    public function getPrijmeni()
    {
        return $this->Prijmeni;
    }
    /**
     * Set Prijmeni value
     * @param string $prijmeni
     * @return \StructType\Subjekt
     */
    public function setPrijmeni($prijmeni = null)
    {
        // validation for constraint: string
        if (!is_null($prijmeni) && !is_string($prijmeni)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prijmeni)), __LINE__);
        }
        $this->Prijmeni = $prijmeni;
        return $this;
    }
    /**
     * Get RC value
     * @return string|null
     */
    public function getRC()
    {
        return $this->RC;
    }
    /**
     * Set RC value
     * @param string $rC
     * @return \StructType\Subjekt
     */
    public function setRC($rC = null)
    {
        // validation for constraint: string
        if (!is_null($rC) && !is_string($rC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rC)), __LINE__);
        }
        $this->RC = $rC;
        return $this;
    }
    /**
     * Get StatPrislusnost value
     * @return string|null
     */
    public function getStatPrislusnost()
    {
        return $this->StatPrislusnost;
    }
    /**
     * Set StatPrislusnost value
     * @param string $statPrislusnost
     * @return \StructType\Subjekt
     */
    public function setStatPrislusnost($statPrislusnost = null)
    {
        // validation for constraint: string
        if (!is_null($statPrislusnost) && !is_string($statPrislusnost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statPrislusnost)), __LINE__);
        }
        $this->StatPrislusnost = $statPrislusnost;
        return $this;
    }
    /**
     * Get Telefon value
     * @return string|null
     */
    public function getTelefon()
    {
        return $this->Telefon;
    }
    /**
     * Set Telefon value
     * @param string $telefon
     * @return \StructType\Subjekt
     */
    public function setTelefon($telefon = null)
    {
        // validation for constraint: string
        if (!is_null($telefon) && !is_string($telefon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telefon)), __LINE__);
        }
        $this->Telefon = $telefon;
        return $this;
    }
    /**
     * Get TitulPred value
     * @return string|null
     */
    public function getTitulPred()
    {
        return $this->TitulPred;
    }
    /**
     * Set TitulPred value
     * @param string $titulPred
     * @return \StructType\Subjekt
     */
    public function setTitulPred($titulPred = null)
    {
        // validation for constraint: string
        if (!is_null($titulPred) && !is_string($titulPred)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($titulPred)), __LINE__);
        }
        $this->TitulPred = $titulPred;
        return $this;
    }
    /**
     * Get TypSubjektu value
     * @return string|null
     */
    public function getTypSubjektu()
    {
        return $this->TypSubjektu;
    }
    /**
     * Set TypSubjektu value
     * @param string $typSubjektu
     * @return \StructType\Subjekt
     */
    public function setTypSubjektu($typSubjektu = null)
    {
        // validation for constraint: string
        if (!is_null($typSubjektu) && !is_string($typSubjektu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($typSubjektu)), __LINE__);
        }
        $this->TypSubjektu = $typSubjektu;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Subjekt
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
