<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OdpovedAdresa StructType
 * @subpackage Structs
 */
class OdpovedAdresa extends AbstractStructBase
{
    /**
     * The Adresa
     * Meta informations extracted from the WSDL
     * - arrayType: tns:Adresa[]
     * - ref: SOAP-ENC:arrayType
     * @var \StructType\Adresa[]
     */
    public $Adresa;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * Constructor method for OdpovedAdresa
     * @uses OdpovedAdresa::setAdresa()
     * @uses OdpovedAdresa::setStatus()
     * @param \StructType\Adresa[] $adresa
     * @param string $status
     */
    public function __construct(array $adresa = array(), $status = null)
    {
        $this
            ->setAdresa($adresa)
            ->setStatus($status);
    }
    /**
     * Get Adresa value
     * @return \StructType\Adresa[]|null
     */
    public function getAdresa()
    {
        return $this->Adresa;
    }
    /**
     * Set Adresa value
     * @throws \InvalidArgumentException
     * @param \StructType\Adresa[] $adresa
     * @return \StructType\OdpovedAdresa
     */
    public function setAdresa(array $adresa = array())
    {
        foreach ($adresa as $odpovedAdresaAdresaItem) {
            // validation for constraint: itemType
            if (!$odpovedAdresaAdresaItem instanceof \StructType\Adresa) {
                throw new \InvalidArgumentException(sprintf('The Adresa property can only contain items of \StructType\Adresa, "%s" given', is_object($odpovedAdresaAdresaItem) ? get_class($odpovedAdresaAdresaItem) : gettype($odpovedAdresaAdresaItem)), __LINE__);
            }
        }
        $this->Adresa = $adresa;
        return $this;
    }
    /**
     * Add item to Adresa value
     * @throws \InvalidArgumentException
     * @param \StructType\Adresa $item
     * @return \StructType\OdpovedAdresa
     */
    public function addToAdresa(\StructType\Adresa $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Adresa) {
            throw new \InvalidArgumentException(sprintf('The Adresa property can only contain items of \StructType\Adresa, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Adresa[] = $item;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\OdpovedAdresa
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OdpovedAdresa
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
