<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ukonceni ServiceType
 * @subpackage Services
 */
class Ukonceni extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UkonceniPS
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UkonceniIn $ukonceniIn
     * @return \StructType\UkonceniOut|bool
     */
    public function UkonceniPS(\StructType\UkonceniIn $ukonceniIn)
    {
        try {
            $this->setResult(self::getSoapClient()->UkonceniPS($ukonceniIn));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UkonceniOut
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
