<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Adresa ServiceType
 * @subpackage Services
 */
class Adresa extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AdresaUIR
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $adresa
     * @return \StructType\OdpovedAdresa[]|bool
     */
    public function AdresaUIR($adresa)
    {
        try {
            $this->setResult(self::getSoapClient()->AdresaUIR($adresa));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OdpovedAdresa[]
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
