<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ISB-PSD-Request StructType
 * @subpackage Structs
 */
class ISB_PSD_Request extends AbstractStructBase
{
    /**
     * The UserID
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserID;
    /**
     * The DomainName
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DomainName;
    /**
     * The MessageContent
     * Meta informations extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MessageContent;
    /**
     * Constructor method for ISB-PSD-Request
     * @uses ISB_PSD_Request::setUserID()
     * @uses ISB_PSD_Request::setDomainName()
     * @uses ISB_PSD_Request::setMessageContent()
     * @param string $userID
     * @param string $domainName
     * @param string $messageContent
     */
    public function __construct($userID = null, $domainName = null, $messageContent = null)
    {
        $this
            ->setUserID($userID)
            ->setDomainName($domainName)
            ->setMessageContent($messageContent);
    }
    /**
     * Get UserID value
     * @return string|null
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param string $userID
     * @return \StructType\ISB_PSD_Request
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: string
        if (!is_null($userID) && !is_string($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get DomainName value
     * @return string|null
     */
    public function getDomainName()
    {
        return $this->DomainName;
    }
    /**
     * Set DomainName value
     * @param string $domainName
     * @return \StructType\ISB_PSD_Request
     */
    public function setDomainName($domainName = null)
    {
        // validation for constraint: string
        if (!is_null($domainName) && !is_string($domainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domainName)), __LINE__);
        }
        $this->DomainName = $domainName;
        return $this;
    }
    /**
     * Get MessageContent value
     * @return string|null
     */
    public function getMessageContent()
    {
        return $this->MessageContent;
    }
    /**
     * Set MessageContent value
     * @param string $messageContent
     * @return \StructType\ISB_PSD_Request
     */
    public function setMessageContent($messageContent = null)
    {
        // validation for constraint: string
        if (!is_null($messageContent) && !is_string($messageContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageContent)), __LINE__);
        }
        $this->MessageContent = $messageContent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ISB_PSD_Request
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
